/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.view.inspector.InspectionCompanion;
import android.view.inspector.PropertyMapper;
import android.view.inspector.PropertyReader;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.appcompat.R;
import androidx.appcompat.widget.LinearLayoutCompat;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntFunction;

@RequiresApi(value=29)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class LinearLayoutCompat$InspectionCompanion
implements InspectionCompanion<LinearLayoutCompat> {
    private boolean mPropertiesMapped = false;
    private int mBaselineAlignedId;
    private int mBaselineAlignedChildIndexId;
    private int mGravityId;
    private int mOrientationId;
    private int mWeightSumId;
    private int mDividerId;
    private int mDividerPaddingId;
    private int mMeasureWithLargestChildId;
    private int mShowDividersId;

    public void mapProperties(@NonNull PropertyMapper propertyMapper) {
        this.mBaselineAlignedId = propertyMapper.mapBoolean("baselineAligned", 16843046);
        this.mBaselineAlignedChildIndexId = propertyMapper.mapInt("baselineAlignedChildIndex", 16843047);
        this.mGravityId = propertyMapper.mapGravity("gravity", 16842927);
        this.mOrientationId = propertyMapper.mapIntEnum("orientation", 16842948, (IntFunction)new IntFunction<String>(){

            @Override
            public String apply(int value) {
                switch (value) {
                    case 0: {
                        return "horizontal";
                    }
                    case 1: {
                        return "vertical";
                    }
                }
                return String.valueOf(value);
            }
        });
        this.mWeightSumId = propertyMapper.mapFloat("weightSum", 16843048);
        this.mDividerId = propertyMapper.mapObject("divider", R.attr.divider);
        this.mDividerPaddingId = propertyMapper.mapInt("dividerPadding", R.attr.dividerPadding);
        this.mMeasureWithLargestChildId = propertyMapper.mapBoolean("measureWithLargestChild", R.attr.measureWithLargestChild);
        this.mShowDividersId = propertyMapper.mapIntFlag("showDividers", R.attr.showDividers, (IntFunction)new IntFunction<Set<String>>(){

            @Override
            public Set<String> apply(int value) {
                HashSet<String> flags = new HashSet<String>();
                if (value == 0) {
                    flags.add("none");
                }
                if (value == 1) {
                    flags.add("beginning");
                }
                if (value == 2) {
                    flags.add("middle");
                }
                if (value == 4) {
                    flags.add("end");
                }
                return flags;
            }
        });
        this.mPropertiesMapped = true;
    }

    public void readProperties(@NonNull LinearLayoutCompat linearLayoutCompat, @NonNull PropertyReader propertyReader) {
        if (!this.mPropertiesMapped) {
            throw new InspectionCompanion.UninitializedPropertyMapException();
        }
        propertyReader.readBoolean(this.mBaselineAlignedId, linearLayoutCompat.isBaselineAligned());
        propertyReader.readInt(this.mBaselineAlignedChildIndexId, linearLayoutCompat.getBaselineAlignedChildIndex());
        propertyReader.readGravity(this.mGravityId, linearLayoutCompat.getGravity());
        propertyReader.readIntEnum(this.mOrientationId, linearLayoutCompat.getOrientation());
        propertyReader.readFloat(this.mWeightSumId, linearLayoutCompat.getWeightSum());
        propertyReader.readObject(this.mDividerId, (Object)linearLayoutCompat.getDividerDrawable());
        propertyReader.readInt(this.mDividerPaddingId, linearLayoutCompat.getDividerPadding());
        propertyReader.readBoolean(this.mMeasureWithLargestChildId, linearLayoutCompat.isMeasureWithLargestChildEnabled());
        propertyReader.readIntFlag(this.mShowDividersId, linearLayoutCompat.getShowDividers());
    }
}

