/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import androidx.annotation.AnyRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FontRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.ColorStateListInflaterCompat;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompat;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourcesCompat {
    private static final String TAG = "ResourcesCompat";
    private static final ThreadLocal<TypedValue> sTempTypedValue = new ThreadLocal();
    private static final WeakHashMap<ColorStateListCacheKey, SparseArray<ColorStateListCacheEntry>> sColorStateCaches = new WeakHashMap(0);
    private static final Object sColorStateCacheLock = new Object();
    @AnyRes
    public static final int ID_NULL = 0;

    @Nullable
    public static Drawable getDrawable(@NonNull Resources res, @DrawableRes int id2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return res.getDrawable(id2, theme);
        }
        return res.getDrawable(id2);
    }

    @Nullable
    public static Drawable getDrawableForDensity(@NonNull Resources res, @DrawableRes int id2, int density, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return res.getDrawableForDensity(id2, density, theme);
        }
        if (Build.VERSION.SDK_INT >= 15) {
            return res.getDrawableForDensity(id2, density);
        }
        return res.getDrawable(id2);
    }

    @ColorInt
    public static int getColor(@NonNull Resources res, @ColorRes int id2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 23) {
            return res.getColor(id2, theme);
        }
        return res.getColor(id2);
    }

    @Nullable
    public static ColorStateList getColorStateList(@NonNull Resources res, @ColorRes int id2, @Nullable Resources.Theme theme) throws Resources.NotFoundException {
        ColorStateListCacheKey key = new ColorStateListCacheKey(res, theme);
        ColorStateList csl = ResourcesCompat.getCachedColorStateList(key, id2);
        if (csl != null) {
            return csl;
        }
        csl = ResourcesCompat.inflateColorStateList(res, id2, theme);
        if (csl != null) {
            ResourcesCompat.addColorStateListToCache(key, id2, csl);
            return csl;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getColorStateList(res, id2, theme);
        }
        return res.getColorStateList(id2);
    }

    @Nullable
    private static ColorStateList inflateColorStateList(Resources resources, int resId, @Nullable Resources.Theme theme) {
        if (ResourcesCompat.isColorInt(resources, resId)) {
            return null;
        }
        XmlResourceParser xml = resources.getXml(resId);
        try {
            return ColorStateListInflaterCompat.createFromXml(resources, (XmlPullParser)xml, theme);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to inflate ColorStateList, leaving it to the framework", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ColorStateList getCachedColorStateList(@NonNull ColorStateListCacheKey key, @ColorRes int resId) {
        Object object = sColorStateCacheLock;
        synchronized (object) {
            ColorStateListCacheEntry entry;
            SparseArray<ColorStateListCacheEntry> entries = sColorStateCaches.get(key);
            if (entries != null && entries.size() > 0 && (entry = (ColorStateListCacheEntry)entries.get(resId)) != null) {
                if (entry.mConfiguration.equals(key.mResources.getConfiguration())) {
                    return entry.mValue;
                }
                entries.remove(resId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addColorStateListToCache(@NonNull ColorStateListCacheKey key, @ColorRes int resId, @NonNull ColorStateList value) {
        Object object = sColorStateCacheLock;
        synchronized (object) {
            SparseArray entries = sColorStateCaches.get(key);
            if (entries == null) {
                entries = new SparseArray();
                sColorStateCaches.put(key, (SparseArray<ColorStateListCacheEntry>)entries);
            }
            entries.append(resId, (Object)new ColorStateListCacheEntry(value, key.mResources.getConfiguration()));
        }
    }

    private static boolean isColorInt(@NonNull Resources resources, @ColorRes int resId) {
        TypedValue value = ResourcesCompat.getTypedValue();
        resources.getValue(resId, value, true);
        return value.type >= 28 && value.type <= 31;
    }

    @NonNull
    private static TypedValue getTypedValue() {
        TypedValue tv = sTempTypedValue.get();
        if (tv == null) {
            tv = new TypedValue();
            sTempTypedValue.set(tv);
        }
        return tv;
    }

    public static float getFloat(@NonNull Resources res, @DimenRes int id2) {
        if (Build.VERSION.SDK_INT >= 29) {
            return ImplApi29.getFloat(res, id2);
        }
        TypedValue value = ResourcesCompat.getTypedValue();
        res.getValue(id2, value, true);
        if (value.type == 4) {
            return value.getFloat();
        }
        throw new Resources.NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
    }

    @Nullable
    public static Typeface getFont(@NonNull Context context, @FontRes int id2) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, id2, new TypedValue(), 0, null, null, false, false);
    }

    @Nullable
    public static Typeface getCachedFont(@NonNull Context context, @FontRes int id2) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, id2, new TypedValue(), 0, null, null, false, true);
    }

    public static void getFont(@NonNull Context context, @FontRes int id2, @NonNull FontCallback fontCallback, @Nullable Handler handler) throws Resources.NotFoundException {
        Preconditions.checkNotNull(fontCallback);
        if (context.isRestricted()) {
            fontCallback.callbackFailAsync(-4, handler);
            return;
        }
        ResourcesCompat.loadFont(context, id2, new TypedValue(), 0, fontCallback, handler, false, false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface getFont(@NonNull Context context, @FontRes int id2, TypedValue value, int style, @Nullable FontCallback fontCallback) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, id2, value, style, fontCallback, null, true, false);
    }

    private static Typeface loadFont(@NonNull Context context, int id2, TypedValue value, int style, @Nullable FontCallback fontCallback, @Nullable Handler handler, boolean isRequestFromLayoutInflator, boolean isCachedOnly) {
        Resources resources = context.getResources();
        resources.getValue(id2, value, true);
        Typeface typeface = ResourcesCompat.loadFont(context, resources, value, id2, style, fontCallback, handler, isRequestFromLayoutInflator, isCachedOnly);
        if (typeface == null && fontCallback == null && !isCachedOnly) {
            throw new Resources.NotFoundException("Font resource ID #0x" + Integer.toHexString(id2) + " could not be retrieved.");
        }
        return typeface;
    }

    private static Typeface loadFont(@NonNull Context context, Resources wrapper, TypedValue value, int id2, int style, @Nullable FontCallback fontCallback, @Nullable Handler handler, boolean isRequestFromLayoutInflator, boolean isCachedOnly) {
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource \"" + wrapper.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Font: " + value);
        }
        String file = value.string.toString();
        if (!file.startsWith("res/")) {
            if (fontCallback != null) {
                fontCallback.callbackFailAsync(-3, handler);
            }
            return null;
        }
        Typeface typeface = TypefaceCompat.findFromCache(wrapper, id2, style);
        if (typeface != null) {
            if (fontCallback != null) {
                fontCallback.callbackSuccessAsync(typeface, handler);
            }
            return typeface;
        }
        if (isCachedOnly) {
            return null;
        }
        try {
            if (file.toLowerCase().endsWith(".xml")) {
                XmlResourceParser rp = wrapper.getXml(id2);
                FontResourcesParserCompat.FamilyResourceEntry familyEntry = FontResourcesParserCompat.parse((XmlPullParser)rp, wrapper);
                if (familyEntry == null) {
                    Log.e((String)TAG, (String)"Failed to find font-family tag");
                    if (fontCallback != null) {
                        fontCallback.callbackFailAsync(-3, handler);
                    }
                    return null;
                }
                return TypefaceCompat.createFromResourcesFamilyXml(context, familyEntry, wrapper, id2, style, fontCallback, handler, isRequestFromLayoutInflator);
            }
            typeface = TypefaceCompat.createFromResourcesFontFile(context, wrapper, id2, file, style);
            if (fontCallback != null) {
                if (typeface != null) {
                    fontCallback.callbackSuccessAsync(typeface, handler);
                } else {
                    fontCallback.callbackFailAsync(-3, handler);
                }
            }
            return typeface;
        }
        catch (XmlPullParserException e) {
            Log.e((String)TAG, (String)("Failed to parse xml resource " + file), (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Failed to read xml resource " + file), (Throwable)e);
        }
        if (fontCallback != null) {
            fontCallback.callbackFailAsync(-3, handler);
        }
        return null;
    }

    private ResourcesCompat() {
    }

    public static final class ThemeCompat {
        private ThemeCompat() {
        }

        public static void rebase(@NonNull Resources.Theme theme) {
            if (Build.VERSION.SDK_INT >= 29) {
                ImplApi29.rebase(theme);
            } else if (Build.VERSION.SDK_INT >= 23) {
                ImplApi23.rebase(theme);
            }
        }

        @RequiresApi(value=23)
        static class ImplApi23 {
            private static final Object sRebaseMethodLock = new Object();
            private static Method sRebaseMethod;
            private static boolean sRebaseMethodFetched;

            private ImplApi23() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static void rebase(@NonNull Resources.Theme theme) {
                Object object = sRebaseMethodLock;
                synchronized (object) {
                    if (!sRebaseMethodFetched) {
                        try {
                            sRebaseMethod = Resources.Theme.class.getDeclaredMethod("rebase", new Class[0]);
                            sRebaseMethod.setAccessible(true);
                        }
                        catch (NoSuchMethodException e) {
                            Log.i((String)ResourcesCompat.TAG, (String)"Failed to retrieve rebase() method", (Throwable)e);
                        }
                        sRebaseMethodFetched = true;
                    }
                    if (sRebaseMethod != null) {
                        try {
                            sRebaseMethod.invoke((Object)theme, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            Log.i((String)ResourcesCompat.TAG, (String)"Failed to invoke rebase() method via reflection", (Throwable)e);
                            sRebaseMethod = null;
                        }
                    }
                }
            }
        }

        @RequiresApi(value=29)
        static class ImplApi29 {
            private ImplApi29() {
            }

            static void rebase(@NonNull Resources.Theme theme) {
                theme.rebase();
            }
        }
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @NonNull
        static ColorStateList getColorStateList(@NonNull Resources res, @ColorRes int id2, @Nullable Resources.Theme theme) {
            return res.getColorStateList(id2, theme);
        }
    }

    @RequiresApi(value=29)
    static class ImplApi29 {
        private ImplApi29() {
        }

        static float getFloat(@NonNull Resources res, @DimenRes int id2) {
            return res.getFloat(id2);
        }
    }

    public static abstract class FontCallback {
        public abstract void onFontRetrieved(@NonNull Typeface var1);

        public abstract void onFontRetrievalFailed(int var1);

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public final void callbackSuccessAsync(final Typeface typeface, @Nullable Handler handler) {
            FontCallback.getHandler(handler).post(new Runnable(){

                @Override
                public void run() {
                    this.onFontRetrieved(typeface);
                }
            });
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public final void callbackFailAsync(final int reason, @Nullable Handler handler) {
            FontCallback.getHandler(handler).post(new Runnable(){

                @Override
                public void run() {
                    this.onFontRetrievalFailed(reason);
                }
            });
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public static Handler getHandler(@Nullable Handler handler) {
            return handler == null ? new Handler(Looper.getMainLooper()) : handler;
        }
    }

    private static class ColorStateListCacheEntry {
        final ColorStateList mValue;
        final Configuration mConfiguration;

        ColorStateListCacheEntry(@NonNull ColorStateList value, @NonNull Configuration configuration) {
            this.mValue = value;
            this.mConfiguration = configuration;
        }
    }

    private static final class ColorStateListCacheKey {
        final Resources mResources;
        @Nullable
        final Resources.Theme mTheme;

        ColorStateListCacheKey(@NonNull Resources resources, @Nullable Resources.Theme theme) {
            this.mResources = resources;
            this.mTheme = theme;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColorStateListCacheKey that = (ColorStateListCacheKey)o;
            return this.mResources.equals(that.mResources) && ObjectsCompat.equals(this.mTheme, that.mTheme);
        }

        public int hashCode() {
            return ObjectsCompat.hash(this.mResources, this.mTheme);
        }
    }
}

