/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class ViewBoundsCheck {
    static final int GT = 1;
    static final int EQ = 2;
    static final int LT = 4;
    static final int CVS_PVS_POS = 0;
    static final int FLAG_CVS_GT_PVS = 1;
    static final int FLAG_CVS_EQ_PVS = 2;
    static final int FLAG_CVS_LT_PVS = 4;
    static final int CVS_PVE_POS = 4;
    static final int FLAG_CVS_GT_PVE = 16;
    static final int FLAG_CVS_EQ_PVE = 32;
    static final int FLAG_CVS_LT_PVE = 64;
    static final int CVE_PVS_POS = 8;
    static final int FLAG_CVE_GT_PVS = 256;
    static final int FLAG_CVE_EQ_PVS = 512;
    static final int FLAG_CVE_LT_PVS = 1024;
    static final int CVE_PVE_POS = 12;
    static final int FLAG_CVE_GT_PVE = 4096;
    static final int FLAG_CVE_EQ_PVE = 8192;
    static final int FLAG_CVE_LT_PVE = 16384;
    static final int MASK = 7;
    final Callback mCallback;
    BoundFlags mBoundFlags;

    ViewBoundsCheck(Callback callback) {
        this.mCallback = callback;
        this.mBoundFlags = new BoundFlags();
    }

    View findOneViewWithinBoundFlags(int fromIndex, int toIndex, int preferredBoundFlags, int acceptableBoundFlags) {
        int start = this.mCallback.getParentStart();
        int end = this.mCallback.getParentEnd();
        int next = toIndex > fromIndex ? 1 : -1;
        View acceptableMatch = null;
        for (int i = fromIndex; i != toIndex; i += next) {
            View child = this.mCallback.getChildAt(i);
            int childStart = this.mCallback.getChildStart(child);
            int childEnd = this.mCallback.getChildEnd(child);
            this.mBoundFlags.setBounds(start, end, childStart, childEnd);
            if (preferredBoundFlags != 0) {
                this.mBoundFlags.resetFlags();
                this.mBoundFlags.addFlags(preferredBoundFlags);
                if (this.mBoundFlags.boundsMatch()) {
                    return child;
                }
            }
            if (acceptableBoundFlags == 0) continue;
            this.mBoundFlags.resetFlags();
            this.mBoundFlags.addFlags(acceptableBoundFlags);
            if (!this.mBoundFlags.boundsMatch()) continue;
            acceptableMatch = child;
        }
        return acceptableMatch;
    }

    boolean isViewWithinBoundFlags(View child, int boundsFlags) {
        this.mBoundFlags.setBounds(this.mCallback.getParentStart(), this.mCallback.getParentEnd(), this.mCallback.getChildStart(child), this.mCallback.getChildEnd(child));
        if (boundsFlags != 0) {
            this.mBoundFlags.resetFlags();
            this.mBoundFlags.addFlags(boundsFlags);
            return this.mBoundFlags.boundsMatch();
        }
        return false;
    }

    static interface Callback {
        public View getChildAt(int var1);

        public int getParentStart();

        public int getParentEnd();

        public int getChildStart(View var1);

        public int getChildEnd(View var1);
    }

    static class BoundFlags {
        int mBoundFlags = 0;
        int mRvStart;
        int mRvEnd;
        int mChildStart;
        int mChildEnd;

        BoundFlags() {
        }

        void setBounds(int rvStart, int rvEnd, int childStart, int childEnd) {
            this.mRvStart = rvStart;
            this.mRvEnd = rvEnd;
            this.mChildStart = childStart;
            this.mChildEnd = childEnd;
        }

        void addFlags(int flags) {
            this.mBoundFlags |= flags;
        }

        void resetFlags() {
            this.mBoundFlags = 0;
        }

        int compare(int x, int y) {
            if (x > y) {
                return 1;
            }
            if (x == y) {
                return 2;
            }
            return 4;
        }

        boolean boundsMatch() {
            if ((this.mBoundFlags & 7) != 0 && (this.mBoundFlags & this.compare(this.mChildStart, this.mRvStart) << 0) == 0) {
                return false;
            }
            if ((this.mBoundFlags & 0x70) != 0 && (this.mBoundFlags & this.compare(this.mChildStart, this.mRvEnd) << 4) == 0) {
                return false;
            }
            if ((this.mBoundFlags & 0x700) != 0 && (this.mBoundFlags & this.compare(this.mChildEnd, this.mRvStart) << 8) == 0) {
                return false;
            }
            return (this.mBoundFlags & 0x7000) == 0 || (this.mBoundFlags & this.compare(this.mChildEnd, this.mRvEnd) << 12) != 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewBounds {
    }
}

