/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.google.android.material.R;

public final class HarmonizedColorAttributes {
    private final int[] attributes;
    @StyleRes
    private final int themeOverlay;
    private static final int[] HARMONIZED_MATERIAL_ATTRIBUTES = new int[]{R.attr.colorError, R.attr.colorOnError, R.attr.colorErrorContainer, R.attr.colorOnErrorContainer};

    @NonNull
    public static HarmonizedColorAttributes create(@NonNull @AttrRes int[] attributes) {
        return new HarmonizedColorAttributes(attributes, 0);
    }

    @NonNull
    public static HarmonizedColorAttributes create(@NonNull @AttrRes int[] attributes, @StyleRes int themeOverlay) {
        return new HarmonizedColorAttributes(attributes, themeOverlay);
    }

    @NonNull
    public static HarmonizedColorAttributes createMaterialDefaults() {
        return HarmonizedColorAttributes.create(HARMONIZED_MATERIAL_ATTRIBUTES, R.style.ThemeOverlay_Material3_HarmonizedColors);
    }

    private HarmonizedColorAttributes(@NonNull @AttrRes int[] attributes, @StyleRes int themeOverlay) {
        if (themeOverlay != 0 && attributes.length == 0) {
            throw new IllegalArgumentException("Theme overlay should be used with the accompanying int[] attributes.");
        }
        this.attributes = attributes;
        this.themeOverlay = themeOverlay;
    }

    @NonNull
    public int[] getAttributes() {
        return this.attributes;
    }

    @StyleRes
    public int getThemeOverlay() {
        return this.themeOverlay;
    }
}

