/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.customtabs.trusted.ITrustedWebActivityService;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.trusted.TrustedWebActivityServiceConnection;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;

class ConnectionHolder
implements ServiceConnection {
    private static final int STATE_AWAITING_CONNECTION = 0;
    private static final int STATE_CONNECTED = 1;
    private static final int STATE_DISCONNECTED = 2;
    private static final int STATE_CANCELLED = 3;
    @NonNull
    private final Runnable mCloseRunnable;
    @NonNull
    private final WrapperFactory mWrapperFactory;
    private int mState = 0;
    @Nullable
    private TrustedWebActivityServiceConnection mService;
    @NonNull
    private List<CallbackToFutureAdapter.Completer<TrustedWebActivityServiceConnection>> mCompleters = new ArrayList<CallbackToFutureAdapter.Completer<TrustedWebActivityServiceConnection>>();
    @Nullable
    private Exception mCancellationException;

    @MainThread
    ConnectionHolder(@NonNull Runnable closeRunnable) {
        this(closeRunnable, new WrapperFactory());
    }

    @MainThread
    ConnectionHolder(@NonNull Runnable closeRunnable, @NonNull WrapperFactory factory) {
        this.mCloseRunnable = closeRunnable;
        this.mWrapperFactory = factory;
    }

    @MainThread
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        this.mService = this.mWrapperFactory.create(componentName, iBinder);
        for (CallbackToFutureAdapter.Completer<TrustedWebActivityServiceConnection> completer : this.mCompleters) {
            completer.set((Object)this.mService);
        }
        this.mCompleters.clear();
        this.mState = 1;
    }

    @MainThread
    public void onServiceDisconnected(ComponentName componentName) {
        this.mService = null;
        this.mCloseRunnable.run();
        this.mState = 2;
    }

    @MainThread
    public void cancel(@NonNull Exception exception) {
        for (CallbackToFutureAdapter.Completer<TrustedWebActivityServiceConnection> completer : this.mCompleters) {
            completer.setException((Throwable)exception);
        }
        this.mCompleters.clear();
        this.mCloseRunnable.run();
        this.mState = 3;
        this.mCancellationException = exception;
    }

    @MainThread
    @NonNull
    public ListenableFuture<TrustedWebActivityServiceConnection> getServiceWrapper() {
        return CallbackToFutureAdapter.getFuture(completer -> {
            switch (this.mState) {
                case 0: {
                    this.mCompleters.add((CallbackToFutureAdapter.Completer<TrustedWebActivityServiceConnection>)completer);
                    break;
                }
                case 1: {
                    if (this.mService == null) {
                        throw new IllegalStateException("ConnectionHolder state is incorrect.");
                    }
                    completer.set((Object)this.mService);
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Service has been disconnected.");
                }
                case 3: {
                    throw this.mCancellationException;
                }
                default: {
                    throw new IllegalStateException("Connection state is invalid");
                }
            }
            return "ConnectionHolder, state = " + this.mState;
        });
    }

    static class WrapperFactory {
        WrapperFactory() {
        }

        @NonNull
        TrustedWebActivityServiceConnection create(ComponentName name, IBinder iBinder) {
            return new TrustedWebActivityServiceConnection(ITrustedWebActivityService.Stub.asInterface(iBinder), name);
        }
    }
}

