/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import com.google.android.material.internal.MaterialCheckable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@UiThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CheckableGroup<T extends MaterialCheckable<T>> {
    private final Map<Integer, T> checkables = new HashMap<Integer, T>();
    private final Set<Integer> checkedIds = new HashSet<Integer>();
    private OnCheckedStateChangeListener onCheckedStateChangeListener;
    private boolean singleSelection;
    private boolean selectionRequired;

    public void setSingleSelection(boolean singleSelection) {
        if (this.singleSelection != singleSelection) {
            this.singleSelection = singleSelection;
            this.clearCheck();
        }
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSelectionRequired(boolean selectionRequired) {
        this.selectionRequired = selectionRequired;
    }

    public boolean isSelectionRequired() {
        return this.selectionRequired;
    }

    public void setOnCheckedStateChangeListener(@Nullable OnCheckedStateChangeListener listener) {
        this.onCheckedStateChangeListener = listener;
    }

    public void addCheckable(T checkable) {
        this.checkables.put(checkable.getId(), checkable);
        if (checkable.isChecked()) {
            this.checkInternal((MaterialCheckable<T>)checkable);
        }
        checkable.setInternalOnCheckedChangeListener(new MaterialCheckable.OnCheckedChangeListener<T>(){

            @Override
            public void onCheckedChanged(T checkable, boolean isChecked) {
                if (isChecked ? CheckableGroup.this.checkInternal(checkable) : CheckableGroup.this.uncheckInternal(checkable, CheckableGroup.this.selectionRequired)) {
                    CheckableGroup.this.onCheckedStateChanged();
                }
            }
        });
    }

    public void removeCheckable(T checkable) {
        checkable.setInternalOnCheckedChangeListener(null);
        this.checkables.remove(checkable.getId());
        this.checkedIds.remove(checkable.getId());
    }

    public void check(@IdRes int id2) {
        MaterialCheckable checkable = (MaterialCheckable)this.checkables.get(id2);
        if (checkable == null) {
            return;
        }
        if (this.checkInternal(checkable)) {
            this.onCheckedStateChanged();
        }
    }

    public void uncheck(@IdRes int id2) {
        MaterialCheckable checkable = (MaterialCheckable)this.checkables.get(id2);
        if (checkable == null) {
            return;
        }
        if (this.uncheckInternal(checkable, this.selectionRequired)) {
            this.onCheckedStateChanged();
        }
    }

    public void clearCheck() {
        boolean checkedStateChanged = !this.checkedIds.isEmpty();
        for (MaterialCheckable checkable : this.checkables.values()) {
            this.uncheckInternal(checkable, false);
        }
        if (checkedStateChanged) {
            this.onCheckedStateChanged();
        }
    }

    @IdRes
    public int getSingleCheckedId() {
        return this.singleSelection && !this.checkedIds.isEmpty() ? this.checkedIds.iterator().next() : -1;
    }

    @NonNull
    public Set<Integer> getCheckedIds() {
        return new HashSet<Integer>(this.checkedIds);
    }

    @NonNull
    public List<Integer> getCheckedIdsSortedByChildOrder(@NonNull ViewGroup parent) {
        Set<Integer> checkedIds = this.getCheckedIds();
        ArrayList<Integer> sortedCheckedIds = new ArrayList<Integer>();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            if (!(child instanceof MaterialCheckable) || !checkedIds.contains(child.getId())) continue;
            sortedCheckedIds.add(child.getId());
        }
        return sortedCheckedIds;
    }

    private boolean checkInternal(@NonNull MaterialCheckable<T> checkable) {
        int id2 = checkable.getId();
        if (this.checkedIds.contains(id2)) {
            return false;
        }
        MaterialCheckable singleCheckedItem = (MaterialCheckable)this.checkables.get(this.getSingleCheckedId());
        if (singleCheckedItem != null) {
            this.uncheckInternal(singleCheckedItem, false);
        }
        boolean checkedStateChanged = this.checkedIds.add(id2);
        if (!checkable.isChecked()) {
            checkable.setChecked(true);
        }
        return checkedStateChanged;
    }

    private boolean uncheckInternal(@NonNull MaterialCheckable<T> checkable, boolean selectionRequired) {
        int id2 = checkable.getId();
        if (!this.checkedIds.contains(id2)) {
            return false;
        }
        if (selectionRequired && this.checkedIds.size() == 1 && this.checkedIds.contains(id2)) {
            checkable.setChecked(true);
            return false;
        }
        boolean checkedStateChanged = this.checkedIds.remove(id2);
        if (checkable.isChecked()) {
            checkable.setChecked(false);
        }
        return checkedStateChanged;
    }

    private void onCheckedStateChanged() {
        if (this.onCheckedStateChangeListener != null) {
            this.onCheckedStateChangeListener.onCheckedStateChanged(this.getCheckedIds());
        }
    }

    public static interface OnCheckedStateChangeListener {
        public void onCheckedStateChanged(@NonNull Set<Integer> var1);
    }
}

