/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CheckedTextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.CheckedTextViewCompat;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class AppCompatCheckedTextViewHelper {
    @NonNull
    private final CheckedTextView mView;
    private ColorStateList mCheckMarkTintList = null;
    private PorterDuff.Mode mCheckMarkTintMode = null;
    private boolean mHasCheckMarkTint = false;
    private boolean mHasCheckMarkTintMode = false;
    private boolean mSkipNextApply;

    AppCompatCheckedTextViewHelper(@NonNull CheckedTextView view) {
        this.mView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromAttributes(@Nullable AttributeSet attrs, int defStyleAttr) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(this.mView.getContext(), attrs, R.styleable.CheckedTextView, defStyleAttr, 0);
        ViewCompat.saveAttributeDataForStyleable((View)this.mView, (Context)this.mView.getContext(), (int[])R.styleable.CheckedTextView, (AttributeSet)attrs, (TypedArray)a.getWrappedTypeArray(), (int)defStyleAttr, (int)0);
        try {
            int resourceId;
            boolean checkMarkDrawableLoaded = false;
            if (a.hasValue(R.styleable.CheckedTextView_checkMarkCompat) && (resourceId = a.getResourceId(R.styleable.CheckedTextView_checkMarkCompat, 0)) != 0) {
                try {
                    this.mView.setCheckMarkDrawable(AppCompatResources.getDrawable((Context)this.mView.getContext(), (int)resourceId));
                    checkMarkDrawableLoaded = true;
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            if (!checkMarkDrawableLoaded && a.hasValue(R.styleable.CheckedTextView_android_checkMark) && (resourceId = a.getResourceId(R.styleable.CheckedTextView_android_checkMark, 0)) != 0) {
                this.mView.setCheckMarkDrawable(AppCompatResources.getDrawable((Context)this.mView.getContext(), (int)resourceId));
            }
            if (a.hasValue(R.styleable.CheckedTextView_checkMarkTint)) {
                CheckedTextViewCompat.setCheckMarkTintList((CheckedTextView)this.mView, (ColorStateList)a.getColorStateList(R.styleable.CheckedTextView_checkMarkTint));
            }
            if (a.hasValue(R.styleable.CheckedTextView_checkMarkTintMode)) {
                CheckedTextViewCompat.setCheckMarkTintMode((CheckedTextView)this.mView, (PorterDuff.Mode)DrawableUtils.parseTintMode((int)a.getInt(R.styleable.CheckedTextView_checkMarkTintMode, -1), null));
            }
        }
        finally {
            a.recycle();
        }
    }

    void setSupportCheckMarkTintList(ColorStateList tint) {
        this.mCheckMarkTintList = tint;
        this.mHasCheckMarkTint = true;
        this.applyCheckMarkTint();
    }

    ColorStateList getSupportCheckMarkTintList() {
        return this.mCheckMarkTintList;
    }

    void setSupportCheckMarkTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mCheckMarkTintMode = tintMode;
        this.mHasCheckMarkTintMode = true;
        this.applyCheckMarkTint();
    }

    PorterDuff.Mode getSupportCheckMarkTintMode() {
        return this.mCheckMarkTintMode;
    }

    void onSetCheckMarkDrawable() {
        if (this.mSkipNextApply) {
            this.mSkipNextApply = false;
            return;
        }
        this.mSkipNextApply = true;
        this.applyCheckMarkTint();
    }

    void applyCheckMarkTint() {
        Drawable checkMarkDrawable = CheckedTextViewCompat.getCheckMarkDrawable((CheckedTextView)this.mView);
        if (checkMarkDrawable != null && (this.mHasCheckMarkTint || this.mHasCheckMarkTintMode)) {
            checkMarkDrawable = DrawableCompat.wrap((Drawable)checkMarkDrawable);
            checkMarkDrawable = checkMarkDrawable.mutate();
            if (this.mHasCheckMarkTint) {
                DrawableCompat.setTintList((Drawable)checkMarkDrawable, (ColorStateList)this.mCheckMarkTintList);
            }
            if (this.mHasCheckMarkTintMode) {
                DrawableCompat.setTintMode((Drawable)checkMarkDrawable, (PorterDuff.Mode)this.mCheckMarkTintMode);
            }
            if (checkMarkDrawable.isStateful()) {
                checkMarkDrawable.setState(this.mView.getDrawableState());
            }
            this.mView.setCheckMarkDrawable(checkMarkDrawable);
        }
    }
}

