/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import java.io.File;
import java.io.InputStream;

public class StringLoader<Data>
implements ModelLoader<String, Data> {
    private final ModelLoader<Uri, Data> uriLoader;

    public StringLoader(ModelLoader<Uri, Data> uriLoader) {
        this.uriLoader = uriLoader;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(@NonNull String model, int width, int height, @NonNull Options options) {
        Uri uri = StringLoader.parseUri(model);
        if (uri == null || !this.uriLoader.handles(uri)) {
            return null;
        }
        return this.uriLoader.buildLoadData(uri, width, height, options);
    }

    @Override
    public boolean handles(@NonNull String model) {
        return true;
    }

    @Nullable
    private static Uri parseUri(String model) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return null;
        }
        if (model.charAt(0) == '/') {
            uri = StringLoader.toFileUri(model);
        } else {
            uri = Uri.parse((String)model);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = StringLoader.toFileUri(model);
            }
        }
        return uri;
    }

    private static Uri toFileUri(String path) {
        return Uri.fromFile((File)new File(path));
    }

    public static final class AssetFileDescriptorFactory
    implements ModelLoaderFactory<String, AssetFileDescriptor> {
        @Override
        public ModelLoader<String, AssetFileDescriptor> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new StringLoader<AssetFileDescriptor>(multiFactory.build(Uri.class, AssetFileDescriptor.class));
        }

        @Override
        public void teardown() {
        }
    }

    public static class FileDescriptorFactory
    implements ModelLoaderFactory<String, ParcelFileDescriptor> {
        @Override
        @NonNull
        public ModelLoader<String, ParcelFileDescriptor> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new StringLoader<ParcelFileDescriptor>(multiFactory.build(Uri.class, ParcelFileDescriptor.class));
        }

        @Override
        public void teardown() {
        }
    }

    public static class StreamFactory
    implements ModelLoaderFactory<String, InputStream> {
        @Override
        @NonNull
        public ModelLoader<String, InputStream> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new StringLoader<InputStream>(multiFactory.build(Uri.class, InputStream.class));
        }

        @Override
        public void teardown() {
        }
    }
}

