/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.text.Editable;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.EmojiCompat;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
final class EmojiInputConnection
extends InputConnectionWrapper {
    private final TextView mTextView;
    private final EmojiCompatDeleteHelper mEmojiCompatDeleteHelper;

    EmojiInputConnection(@NonNull TextView textView, @NonNull InputConnection inputConnection, @NonNull EditorInfo outAttrs) {
        this(textView, inputConnection, outAttrs, new EmojiCompatDeleteHelper());
    }

    EmojiInputConnection(@NonNull TextView textView, @NonNull InputConnection inputConnection, @NonNull EditorInfo outAttrs, @NonNull EmojiCompatDeleteHelper emojiCompatDeleteHelper) {
        super(inputConnection, false);
        this.mTextView = textView;
        this.mEmojiCompatDeleteHelper = emojiCompatDeleteHelper;
        this.mEmojiCompatDeleteHelper.updateEditorInfoAttrs(outAttrs);
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        boolean result = this.mEmojiCompatDeleteHelper.handleDeleteSurroundingText((InputConnection)this, this.getEditable(), beforeLength, afterLength, false);
        return result || super.deleteSurroundingText(beforeLength, afterLength);
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        boolean result = this.mEmojiCompatDeleteHelper.handleDeleteSurroundingText((InputConnection)this, this.getEditable(), beforeLength, afterLength, true);
        return result || super.deleteSurroundingTextInCodePoints(beforeLength, afterLength);
    }

    private Editable getEditable() {
        return this.mTextView.getEditableText();
    }

    public static class EmojiCompatDeleteHelper {
        public boolean handleDeleteSurroundingText(@NonNull InputConnection inputConnection, @NonNull Editable editable, @IntRange(from=0L) int beforeLength, @IntRange(from=0L) int afterLength, boolean inCodePoints) {
            return EmojiCompat.handleDeleteSurroundingText((InputConnection)inputConnection, (Editable)editable, (int)beforeLength, (int)afterLength, (boolean)inCodePoints);
        }

        public void updateEditorInfoAttrs(@NonNull EditorInfo outAttrs) {
            if (EmojiCompat.isConfigured()) {
                EmojiCompat.get().updateEditorInfo(outAttrs);
            }
        }
    }
}

