/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.R;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.target.BaseTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public abstract class ViewTarget<T extends View, Z>
extends BaseTarget<Z> {
    private static final String TAG = "ViewTarget";
    private static boolean isTagUsedAtLeastOnce;
    private static int tagId;
    protected final T view;
    private final SizeDeterminer sizeDeterminer;
    @Nullable
    private View.OnAttachStateChangeListener attachStateListener;
    private boolean isClearedByUs;
    private boolean isAttachStateListenerAdded;

    public ViewTarget(@NonNull T view) {
        this.view = (View)Preconditions.checkNotNull(view);
        this.sizeDeterminer = new SizeDeterminer((View)view);
    }

    @Deprecated
    public ViewTarget(@NonNull T view, boolean waitForLayout) {
        this(view);
        if (waitForLayout) {
            this.waitForLayout();
        }
    }

    @NonNull
    public final ViewTarget<T, Z> clearOnDetach() {
        if (this.attachStateListener != null) {
            return this;
        }
        this.attachStateListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                ViewTarget.this.resumeMyRequest();
            }

            public void onViewDetachedFromWindow(View v) {
                ViewTarget.this.pauseMyRequest();
            }
        };
        this.maybeAddAttachStateListener();
        return this;
    }

    void resumeMyRequest() {
        Request request = this.getRequest();
        if (request != null && request.isCleared()) {
            request.begin();
        }
    }

    void pauseMyRequest() {
        Request request = this.getRequest();
        if (request != null) {
            this.isClearedByUs = true;
            request.clear();
            this.isClearedByUs = false;
        }
    }

    @NonNull
    public final ViewTarget<T, Z> waitForLayout() {
        this.sizeDeterminer.waitForLayout = true;
        return this;
    }

    @Override
    @CallSuper
    public void onLoadStarted(@Nullable Drawable placeholder) {
        super.onLoadStarted(placeholder);
        this.maybeAddAttachStateListener();
    }

    private void maybeAddAttachStateListener() {
        if (this.attachStateListener == null || this.isAttachStateListenerAdded) {
            return;
        }
        this.view.addOnAttachStateChangeListener(this.attachStateListener);
        this.isAttachStateListenerAdded = true;
    }

    private void maybeRemoveAttachStateListener() {
        if (this.attachStateListener == null || !this.isAttachStateListenerAdded) {
            return;
        }
        this.view.removeOnAttachStateChangeListener(this.attachStateListener);
        this.isAttachStateListenerAdded = false;
    }

    @NonNull
    public T getView() {
        return this.view;
    }

    @Override
    @CallSuper
    public void getSize(@NonNull SizeReadyCallback cb) {
        this.sizeDeterminer.getSize(cb);
    }

    @Override
    @CallSuper
    public void removeCallback(@NonNull SizeReadyCallback cb) {
        this.sizeDeterminer.removeCallback(cb);
    }

    @Override
    @CallSuper
    public void onLoadCleared(@Nullable Drawable placeholder) {
        super.onLoadCleared(placeholder);
        this.sizeDeterminer.clearCallbacksAndListener();
        if (!this.isClearedByUs) {
            this.maybeRemoveAttachStateListener();
        }
    }

    @Override
    public void setRequest(@Nullable Request request) {
        this.setTag(request);
    }

    @Override
    @Nullable
    public Request getRequest() {
        Object tag = this.getTag();
        Request request = null;
        if (tag != null) {
            if (tag instanceof Request) {
                request = (Request)tag;
            } else {
                throw new IllegalArgumentException("You must not call setTag() on a view Glide is targeting");
            }
        }
        return request;
    }

    public String toString() {
        return "Target for: " + this.view;
    }

    private void setTag(@Nullable Object tag) {
        isTagUsedAtLeastOnce = true;
        this.view.setTag(tagId, tag);
    }

    @Nullable
    private Object getTag() {
        return this.view.getTag(tagId);
    }

    @Deprecated
    public static void setTagId(int tagId) {
        if (isTagUsedAtLeastOnce) {
            throw new IllegalArgumentException("You cannot set the tag id more than once or change the tag id after the first request has been made");
        }
        ViewTarget.tagId = tagId;
    }

    static {
        tagId = R.id.glide_custom_view_target_tag;
    }

    @VisibleForTesting
    static final class SizeDeterminer {
        private static final int PENDING_SIZE = 0;
        @VisibleForTesting
        @Nullable
        static Integer maxDisplayLength;
        private final View view;
        private final List<SizeReadyCallback> cbs = new ArrayList<SizeReadyCallback>();
        boolean waitForLayout;
        @Nullable
        private SizeDeterminerLayoutListener layoutListener;

        SizeDeterminer(@NonNull View view) {
            this.view = view;
        }

        private static int getMaxDisplayLength(@NonNull Context context) {
            if (maxDisplayLength == null) {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = Preconditions.checkNotNull(windowManager).getDefaultDisplay();
                Point displayDimensions = new Point();
                display.getSize(displayDimensions);
                maxDisplayLength = Math.max(displayDimensions.x, displayDimensions.y);
            }
            return maxDisplayLength;
        }

        private void notifyCbs(int width, int height) {
            for (SizeReadyCallback cb : new ArrayList<SizeReadyCallback>(this.cbs)) {
                cb.onSizeReady(width, height);
            }
        }

        void checkCurrentDimens() {
            int currentHeight;
            if (this.cbs.isEmpty()) {
                return;
            }
            int currentWidth = this.getTargetWidth();
            if (!this.isViewStateAndSizeValid(currentWidth, currentHeight = this.getTargetHeight())) {
                return;
            }
            this.notifyCbs(currentWidth, currentHeight);
            this.clearCallbacksAndListener();
        }

        void getSize(@NonNull SizeReadyCallback cb) {
            int currentHeight;
            int currentWidth = this.getTargetWidth();
            if (this.isViewStateAndSizeValid(currentWidth, currentHeight = this.getTargetHeight())) {
                cb.onSizeReady(currentWidth, currentHeight);
                return;
            }
            if (!this.cbs.contains(cb)) {
                this.cbs.add(cb);
            }
            if (this.layoutListener == null) {
                ViewTreeObserver observer = this.view.getViewTreeObserver();
                this.layoutListener = new SizeDeterminerLayoutListener(this);
                observer.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
            }
        }

        void removeCallback(@NonNull SizeReadyCallback cb) {
            this.cbs.remove(cb);
        }

        void clearCallbacksAndListener() {
            ViewTreeObserver observer = this.view.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
            }
            this.layoutListener = null;
            this.cbs.clear();
        }

        private boolean isViewStateAndSizeValid(int width, int height) {
            return this.isDimensionValid(width) && this.isDimensionValid(height);
        }

        private int getTargetHeight() {
            int verticalPadding = this.view.getPaddingTop() + this.view.getPaddingBottom();
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            int layoutParamSize = layoutParams != null ? layoutParams.height : 0;
            return this.getTargetDimen(this.view.getHeight(), layoutParamSize, verticalPadding);
        }

        private int getTargetWidth() {
            int horizontalPadding = this.view.getPaddingLeft() + this.view.getPaddingRight();
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            int layoutParamSize = layoutParams != null ? layoutParams.width : 0;
            return this.getTargetDimen(this.view.getWidth(), layoutParamSize, horizontalPadding);
        }

        private int getTargetDimen(int viewSize, int paramSize, int paddingSize) {
            int adjustedParamSize = paramSize - paddingSize;
            if (adjustedParamSize > 0) {
                return adjustedParamSize;
            }
            if (this.waitForLayout && this.view.isLayoutRequested()) {
                return 0;
            }
            int adjustedViewSize = viewSize - paddingSize;
            if (adjustedViewSize > 0) {
                return adjustedViewSize;
            }
            if (!this.view.isLayoutRequested() && paramSize == -2) {
                if (Log.isLoggable((String)ViewTarget.TAG, (int)4)) {
                    Log.i((String)ViewTarget.TAG, (String)"Glide treats LayoutParams.WRAP_CONTENT as a request for an image the size of this device's screen dimensions. If you want to load the original image and are ok with the corresponding memory cost and OOMs (depending on the input size), use override(Target.SIZE_ORIGINAL). Otherwise, use LayoutParams.MATCH_PARENT, set layout_width and layout_height to fixed dimension, or use .override() with fixed dimensions.");
                }
                return SizeDeterminer.getMaxDisplayLength(this.view.getContext());
            }
            return 0;
        }

        private boolean isDimensionValid(int size) {
            return size > 0 || size == Integer.MIN_VALUE;
        }

        private static final class SizeDeterminerLayoutListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final WeakReference<SizeDeterminer> sizeDeterminerRef;

            SizeDeterminerLayoutListener(@NonNull SizeDeterminer sizeDeterminer) {
                this.sizeDeterminerRef = new WeakReference<SizeDeterminer>(sizeDeterminer);
            }

            public boolean onPreDraw() {
                SizeDeterminer sizeDeterminer;
                if (Log.isLoggable((String)ViewTarget.TAG, (int)2)) {
                    Log.v((String)ViewTarget.TAG, (String)("OnGlobalLayoutListener called attachStateListener=" + this));
                }
                if ((sizeDeterminer = (SizeDeterminer)this.sizeDeterminerRef.get()) != null) {
                    sizeDeterminer.checkCurrentDimens();
                }
                return true;
            }
        }
    }
}

