/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.util.Preconditions;
import java.security.MessageDigest;

public final class Option<T> {
    private static final CacheKeyUpdater<Object> EMPTY_UPDATER = new CacheKeyUpdater<Object>(){

        @Override
        public void update(@NonNull byte[] keyBytes, @NonNull Object value, @NonNull MessageDigest messageDigest) {
        }
    };
    private final T defaultValue;
    private final CacheKeyUpdater<T> cacheKeyUpdater;
    private final String key;
    private volatile byte[] keyBytes;

    @NonNull
    public static <T> Option<T> memory(@NonNull String key) {
        return new Option<Object>(key, null, Option.emptyUpdater());
    }

    @NonNull
    public static <T> Option<T> memory(@NonNull String key, @NonNull T defaultValue) {
        return new Option<T>(key, defaultValue, Option.emptyUpdater());
    }

    @NonNull
    public static <T> Option<T> disk(@NonNull String key, @NonNull CacheKeyUpdater<T> cacheKeyUpdater) {
        return new Option<Object>(key, null, cacheKeyUpdater);
    }

    @NonNull
    public static <T> Option<T> disk(@NonNull String key, @Nullable T defaultValue, @NonNull CacheKeyUpdater<T> cacheKeyUpdater) {
        return new Option<T>(key, defaultValue, cacheKeyUpdater);
    }

    private Option(@NonNull String key, @Nullable T defaultValue, @NonNull CacheKeyUpdater<T> cacheKeyUpdater) {
        this.key = Preconditions.checkNotEmpty(key);
        this.defaultValue = defaultValue;
        this.cacheKeyUpdater = Preconditions.checkNotNull(cacheKeyUpdater);
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void update(@NonNull T value, @NonNull MessageDigest messageDigest) {
        this.cacheKeyUpdater.update(this.getKeyBytes(), value, messageDigest);
    }

    @NonNull
    private byte[] getKeyBytes() {
        if (this.keyBytes == null) {
            this.keyBytes = this.key.getBytes(Key.CHARSET);
        }
        return this.keyBytes;
    }

    public boolean equals(Object o) {
        if (o instanceof Option) {
            Option other = (Option)o;
            return this.key.equals(other.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @NonNull
    private static <T> CacheKeyUpdater<T> emptyUpdater() {
        return EMPTY_UPDATER;
    }

    public String toString() {
        return "Option{key='" + this.key + '\'' + '}';
    }

    public static interface CacheKeyUpdater<T> {
        public void update(@NonNull byte[] var1, @NonNull T var2, @NonNull MessageDigest var3);
    }
}

