/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import android.support.customtabs.ICustomTabsService;
import android.widget.RemoteViews;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsSessionToken;
import java.util.List;

public final class CustomTabsSession {
    private static final String TAG = "CustomTabsSession";
    private final Object mLock = new Object();
    private final ICustomTabsService mService;
    private final ICustomTabsCallback mCallback;
    private final ComponentName mComponentName;
    @Nullable
    private final PendingIntent mId;

    @VisibleForTesting
    @NonNull
    public static CustomTabsSession createMockSessionForTesting(@NonNull ComponentName componentName) {
        return new CustomTabsSession(new MockSession(), new CustomTabsSessionToken.MockCallback(), componentName, null);
    }

    CustomTabsSession(ICustomTabsService service, ICustomTabsCallback callback, ComponentName componentName, @Nullable PendingIntent sessionId) {
        this.mService = service;
        this.mCallback = callback;
        this.mComponentName = componentName;
        this.mId = sessionId;
    }

    public boolean mayLaunchUrl(@Nullable Uri url, @Nullable Bundle extras, @Nullable List<Bundle> otherLikelyBundles) {
        extras = this.createBundleWithId(extras);
        try {
            return this.mService.mayLaunchUrl(this.mCallback, url, extras, otherLikelyBundles);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setActionButton(@NonNull Bitmap icon, @NonNull String description) {
        Bundle bundle = new Bundle();
        bundle.putParcelable("android.support.customtabs.customaction.ICON", (Parcelable)icon);
        bundle.putString("android.support.customtabs.customaction.DESCRIPTION", description);
        Bundle metaBundle = new Bundle();
        metaBundle.putBundle("android.support.customtabs.extra.ACTION_BUTTON_BUNDLE", bundle);
        this.addIdToBundle(bundle);
        try {
            return this.mService.updateVisuals(this.mCallback, metaBundle);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setSecondaryToolbarViews(@Nullable RemoteViews remoteViews, @Nullable int[] clickableIDs, @Nullable PendingIntent pendingIntent) {
        Bundle bundle = new Bundle();
        bundle.putParcelable("android.support.customtabs.extra.EXTRA_REMOTEVIEWS", (Parcelable)remoteViews);
        bundle.putIntArray("android.support.customtabs.extra.EXTRA_REMOTEVIEWS_VIEW_IDS", clickableIDs);
        bundle.putParcelable("android.support.customtabs.extra.EXTRA_REMOTEVIEWS_PENDINGINTENT", (Parcelable)pendingIntent);
        this.addIdToBundle(bundle);
        try {
            return this.mService.updateVisuals(this.mCallback, bundle);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Deprecated
    public boolean setToolbarItem(int id2, @NonNull Bitmap icon, @NonNull String description) {
        Bundle bundle = new Bundle();
        bundle.putInt("android.support.customtabs.customaction.ID", id2);
        bundle.putParcelable("android.support.customtabs.customaction.ICON", (Parcelable)icon);
        bundle.putString("android.support.customtabs.customaction.DESCRIPTION", description);
        Bundle metaBundle = new Bundle();
        metaBundle.putBundle("android.support.customtabs.extra.ACTION_BUTTON_BUNDLE", bundle);
        this.addIdToBundle(metaBundle);
        try {
            return this.mService.updateVisuals(this.mCallback, metaBundle);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean requestPostMessageChannel(@NonNull Uri postMessageOrigin) {
        try {
            if (this.mId != null) {
                return this.mService.requestPostMessageChannelWithExtras(this.mCallback, postMessageOrigin, this.createBundleWithId(null));
            }
            return this.mService.requestPostMessageChannel(this.mCallback, postMessageOrigin);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int postMessage(@NonNull String message, @Nullable Bundle extras) {
        extras = this.createBundleWithId(extras);
        Object object = this.mLock;
        synchronized (object) {
            try {
                return this.mService.postMessage(this.mCallback, message, extras);
            }
            catch (RemoteException e) {
                return -2;
            }
        }
    }

    public boolean validateRelationship(int relation, @NonNull Uri origin, @Nullable Bundle extras) {
        if (relation < 1 || relation > 2) {
            return false;
        }
        extras = this.createBundleWithId(extras);
        try {
            return this.mService.validateRelationship(this.mCallback, relation, origin, extras);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean receiveFile(@NonNull Uri uri, int purpose, @Nullable Bundle extras) {
        extras = this.createBundleWithId(extras);
        try {
            return this.mService.receiveFile(this.mCallback, uri, purpose, extras);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private Bundle createBundleWithId(@Nullable Bundle bundle) {
        Bundle bundleWithId = new Bundle();
        if (bundle != null) {
            bundleWithId.putAll(bundle);
        }
        this.addIdToBundle(bundleWithId);
        return bundleWithId;
    }

    private void addIdToBundle(Bundle bundle) {
        if (this.mId != null) {
            bundle.putParcelable("android.support.customtabs.extra.SESSION_ID", (Parcelable)this.mId);
        }
    }

    IBinder getBinder() {
        return this.mCallback.asBinder();
    }

    ComponentName getComponentName() {
        return this.mComponentName;
    }

    @Nullable
    PendingIntent getId() {
        return this.mId;
    }

    static class MockSession
    extends ICustomTabsService.Stub {
        MockSession() {
        }

        @Override
        public boolean warmup(long flags) throws RemoteException {
            return false;
        }

        @Override
        public boolean newSession(ICustomTabsCallback callback) throws RemoteException {
            return false;
        }

        @Override
        public boolean newSessionWithExtras(ICustomTabsCallback callback, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public boolean mayLaunchUrl(ICustomTabsCallback callback, Uri url, Bundle extras, List<Bundle> otherLikelyBundles) throws RemoteException {
            return false;
        }

        @Override
        public Bundle extraCommand(String commandName, Bundle args) throws RemoteException {
            return null;
        }

        @Override
        public boolean updateVisuals(ICustomTabsCallback callback, Bundle bundle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestPostMessageChannel(ICustomTabsCallback callback, Uri postMessageOrigin) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestPostMessageChannelWithExtras(ICustomTabsCallback callback, Uri postMessageOrigin, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public int postMessage(ICustomTabsCallback callback, String message, Bundle extras) throws RemoteException {
            return 0;
        }

        @Override
        public boolean validateRelationship(ICustomTabsCallback callback, int relation, Uri origin, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public boolean receiveFile(ICustomTabsCallback callback, Uri uri, int purpose, Bundle extras) throws RemoteException {
            return false;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class PendingSession {
        @Nullable
        private final CustomTabsCallback mCallback;
        @Nullable
        private final PendingIntent mId;

        PendingSession(@Nullable CustomTabsCallback callback, @Nullable PendingIntent sessionId) {
            this.mCallback = callback;
            this.mId = sessionId;
        }

        @Nullable
        PendingIntent getId() {
            return this.mId;
        }

        @Nullable
        CustomTabsCallback getCallback() {
            return this.mCallback;
        }
    }
}

