/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.resources;

import android.graphics.Typeface;
import androidx.annotation.RestrictTo;
import com.google.android.material.resources.TextAppearanceFontCallback;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CancelableFontCallback
extends TextAppearanceFontCallback {
    private final Typeface fallbackFont;
    private final ApplyFont applyFont;
    private boolean cancelled;

    public CancelableFontCallback(ApplyFont applyFont, Typeface fallbackFont) {
        this.fallbackFont = fallbackFont;
        this.applyFont = applyFont;
    }

    @Override
    public void onFontRetrieved(Typeface font, boolean fontResolvedSynchronously) {
        this.updateIfNotCancelled(font);
    }

    @Override
    public void onFontRetrievalFailed(int reason) {
        this.updateIfNotCancelled(this.fallbackFont);
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void updateIfNotCancelled(Typeface updatedFont) {
        if (!this.cancelled) {
            this.applyFont.apply(updatedFont);
        }
    }

    public static interface ApplyFont {
        public void apply(Typeface var1);
    }
}

