/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.embedding.MatcherUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Landroidx/window/embedding/ActivityFilter;", "", "componentName", "Landroid/content/ComponentName;", "intentAction", "", "(Landroid/content/ComponentName;Ljava/lang/String;)V", "getComponentName", "()Landroid/content/ComponentName;", "getIntentAction", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "matchesActivity", "activity", "Landroid/app/Activity;", "matchesIntent", "intent", "Landroid/content/Intent;", "toString", "window_release"})
@ExperimentalWindowApi
public final class ActivityFilter {
    @NotNull
    private final ComponentName componentName;
    @Nullable
    private final String intentAction;

    public ActivityFilter(@NotNull ComponentName componentName, @Nullable String intentAction) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        this.intentAction = intentAction;
        String string = this.componentName.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentName.packageName");
        String packageName = string;
        String string2 = this.componentName.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"componentName.className");
        String className = string2;
        if (!(((CharSequence)packageName).length() > 0)) {
            boolean $i$a$-require-ActivityFilter$52 = false;
            String $i$a$-require-ActivityFilter$52 = "Package name must not be empty";
            throw new IllegalArgumentException($i$a$-require-ActivityFilter$52.toString());
        }
        if (!(((CharSequence)className).length() > 0)) {
            boolean $i$a$-require-ActivityFilter$62 = false;
            String $i$a$-require-ActivityFilter$62 = "Activity class name must not be empty.";
            throw new IllegalArgumentException($i$a$-require-ActivityFilter$62.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)packageName, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)packageName, (String)"*", (int)0, (boolean)false, (int)6, null) == packageName.length() - 1)) {
            boolean $i$a$-require-ActivityFilter$72 = false;
            String $i$a$-require-ActivityFilter$72 = "Wildcard in package name is only allowed at the end.";
            throw new IllegalArgumentException($i$a$-require-ActivityFilter$72.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)className, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)className, (String)"*", (int)0, (boolean)false, (int)6, null) == className.length() - 1)) {
            boolean bl = false;
            String string3 = "Wildcard in class name is only allowed at the end.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @NotNull
    public final ComponentName getComponentName() {
        return this.componentName;
    }

    @Nullable
    public final String getIntentAction() {
        return this.intentAction;
    }

    public final boolean matchesIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        boolean match = !MatcherUtils.INSTANCE.areComponentsMatching$window_release(intent.getComponent(), this.componentName) ? false : this.intentAction == null || Intrinsics.areEqual((Object)this.intentAction, (Object)intent.getAction());
        return match;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!MatcherUtils.INSTANCE.areActivityOrIntentComponentsMatching$window_release(activity, this.componentName)) return false;
        if (this.intentAction == null) return true;
        Intent intent = activity.getIntent();
        if (!Intrinsics.areEqual((Object)this.intentAction, (Object)(intent == null ? null : intent.getAction()))) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActivityFilter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.componentName, (Object)((ActivityFilter)other).componentName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.intentAction, (Object)((ActivityFilter)other).intentAction);
    }

    public int hashCode() {
        int n;
        int result = this.componentName.hashCode();
        String string = this.intentAction;
        result = 31 * result + (string == null ? 0 : (n = string.hashCode()));
        return result;
    }

    @NotNull
    public String toString() {
        return "ActivityFilter(componentName=" + this.componentName + ", intentAction=" + this.intentAction + ')';
    }
}

