/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.drawable;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Xml;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.XmlRes;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DrawableUtils {
    private DrawableUtils() {
    }

    @Nullable
    public static PorterDuffColorFilter updateTintFilter(@NonNull Drawable drawable2, @Nullable ColorStateList tint, @Nullable PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(drawable2.getState(), 0);
        return new PorterDuffColorFilter(color2, tintMode);
    }

    @NonNull
    public static AttributeSet parseDrawableXml(@NonNull Context context, @XmlRes int id2, @NonNull CharSequence startTag) {
        try {
            int type;
            XmlResourceParser parser = context.getResources().getXml(id2);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            if (!TextUtils.equals((CharSequence)parser.getName(), (CharSequence)startTag)) {
                throw new XmlPullParserException("Must have a <" + startTag + "> start tag");
            }
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            return attrs;
        }
        catch (IOException | XmlPullParserException e) {
            Resources.NotFoundException exception = new Resources.NotFoundException("Can't load badge resource ID #0x" + Integer.toHexString(id2));
            exception.initCause(e);
            throw exception;
        }
    }

    @TargetApi(value=21)
    public static void setRippleDrawableRadius(@Nullable RippleDrawable drawable2, int radius) {
        if (Build.VERSION.SDK_INT >= 23) {
            drawable2.setRadius(radius);
        } else {
            try {
                Method setMaxRadiusMethod = RippleDrawable.class.getDeclaredMethod("setMaxRadius", Integer.TYPE);
                setMaxRadiusMethod.invoke((Object)drawable2, radius);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Couldn't set RippleDrawable radius", e);
            }
        }
    }
}

