/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.UtcDates;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;

final class Month
implements Comparable<Month>,
Parcelable {
    @NonNull
    private final Calendar firstOfMonth;
    final int month;
    final int year;
    final int daysInWeek;
    final int daysInMonth;
    final long timeInMillis;
    @Nullable
    private String longName;
    public static final Parcelable.Creator<Month> CREATOR = new Parcelable.Creator<Month>(){

        @NonNull
        public Month createFromParcel(@NonNull Parcel source) {
            int year = source.readInt();
            int month = source.readInt();
            return Month.create(year, month);
        }

        @NonNull
        public Month[] newArray(int size) {
            return new Month[size];
        }
    };

    private Month(@NonNull Calendar rawCalendar) {
        rawCalendar.set(5, 1);
        this.firstOfMonth = UtcDates.getDayCopy(rawCalendar);
        this.month = this.firstOfMonth.get(2);
        this.year = this.firstOfMonth.get(1);
        this.daysInWeek = this.firstOfMonth.getMaximum(7);
        this.daysInMonth = this.firstOfMonth.getActualMaximum(5);
        this.timeInMillis = this.firstOfMonth.getTimeInMillis();
    }

    @NonNull
    static Month create(long timeInMillis) {
        Calendar calendar = UtcDates.getUtcCalendar();
        calendar.setTimeInMillis(timeInMillis);
        return new Month(calendar);
    }

    @NonNull
    static Month create(int year, int month) {
        Calendar calendar = UtcDates.getUtcCalendar();
        calendar.set(1, year);
        calendar.set(2, month);
        return new Month(calendar);
    }

    @NonNull
    static Month current() {
        return new Month(UtcDates.getTodayCalendar());
    }

    int daysFromStartOfWeekToFirstOfMonth() {
        int difference = this.firstOfMonth.get(7) - this.firstOfMonth.getFirstDayOfWeek();
        if (difference < 0) {
            difference += this.daysInWeek;
        }
        return difference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Month)) {
            return false;
        }
        Month that = (Month)o;
        return this.month == that.month && this.year == that.year;
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{this.month, this.year};
        return Arrays.hashCode(hashedFields);
    }

    @Override
    public int compareTo(@NonNull Month other) {
        return this.firstOfMonth.compareTo(other.firstOfMonth);
    }

    int monthsUntil(@NonNull Month other) {
        if (this.firstOfMonth instanceof GregorianCalendar) {
            return (other.year - this.year) * 12 + (other.month - this.month);
        }
        throw new IllegalArgumentException("Only Gregorian calendars are supported.");
    }

    long getStableId() {
        return this.firstOfMonth.getTimeInMillis();
    }

    long getDay(int day) {
        Calendar dayCalendar = UtcDates.getDayCopy(this.firstOfMonth);
        dayCalendar.set(5, day);
        return dayCalendar.getTimeInMillis();
    }

    int getDayOfMonth(long date) {
        Calendar dayCalendar = UtcDates.getDayCopy(this.firstOfMonth);
        dayCalendar.setTimeInMillis(date);
        return dayCalendar.get(5);
    }

    @NonNull
    Month monthsLater(int months) {
        Calendar laterMonth = UtcDates.getDayCopy(this.firstOfMonth);
        laterMonth.add(2, months);
        return new Month(laterMonth);
    }

    @NonNull
    String getLongName() {
        if (this.longName == null) {
            this.longName = DateStrings.getYearMonth(this.firstOfMonth.getTimeInMillis());
        }
        return this.longName;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.year);
        dest.writeInt(this.month);
    }
}

