/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.google.android.material.R;
import com.google.android.material.color.DynamicColorsOptions;
import com.google.android.material.color.ThemeUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DynamicColors {
    private static final int[] DYNAMIC_COLOR_THEME_OVERLAY_ATTRIBUTE = new int[]{R.attr.dynamicColorThemeOverlay};
    private static final DeviceSupportCondition DEFAULT_DEVICE_SUPPORT_CONDITION = new DeviceSupportCondition(){

        @Override
        public boolean isSupported() {
            return true;
        }
    };
    @SuppressLint(value={"PrivateApi"})
    private static final DeviceSupportCondition SAMSUNG_DEVICE_SUPPORT_CONDITION = new DeviceSupportCondition(){
        private Long version;

        @Override
        public boolean isSupported() {
            if (this.version == null) {
                try {
                    Method method = Build.class.getDeclaredMethod("getLong", String.class);
                    method.setAccessible(true);
                    this.version = (long)((Long)method.invoke(null, "ro.build.version.oneui"));
                }
                catch (Exception e) {
                    this.version = -1L;
                }
            }
            return this.version >= 40100L;
        }
    };
    private static final Map<String, DeviceSupportCondition> DYNAMIC_COLOR_SUPPORTED_MANUFACTURERS;
    private static final Map<String, DeviceSupportCondition> DYNAMIC_COLOR_SUPPORTED_BRANDS;
    private static final int USE_DEFAULT_THEME_OVERLAY = 0;

    private DynamicColors() {
    }

    public static void applyToActivitiesIfAvailable(@NonNull Application application) {
        DynamicColors.applyToActivitiesIfAvailable(application, new DynamicColorsOptions.Builder().build());
    }

    @Deprecated
    public static void applyToActivitiesIfAvailable(@NonNull Application application, @StyleRes int theme) {
        DynamicColors.applyToActivitiesIfAvailable(application, new DynamicColorsOptions.Builder().setThemeOverlay(theme).build());
    }

    @Deprecated
    public static void applyToActivitiesIfAvailable(@NonNull Application application, @NonNull Precondition precondition) {
        DynamicColors.applyToActivitiesIfAvailable(application, new DynamicColorsOptions.Builder().setPrecondition(precondition).build());
    }

    @Deprecated
    public static void applyToActivitiesIfAvailable(@NonNull Application application, @StyleRes int theme, @NonNull Precondition precondition) {
        DynamicColors.applyToActivitiesIfAvailable(application, new DynamicColorsOptions.Builder().setThemeOverlay(theme).setPrecondition(precondition).build());
    }

    public static void applyToActivitiesIfAvailable(@NonNull Application application, @NonNull DynamicColorsOptions dynamicColorsOptions) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new DynamicColorsActivityLifecycleCallbacks(dynamicColorsOptions));
    }

    @Deprecated
    public static void applyIfAvailable(@NonNull Activity activity) {
        DynamicColors.applyToActivityIfAvailable(activity);
    }

    @Deprecated
    public static void applyIfAvailable(@NonNull Activity activity, @StyleRes int theme) {
        DynamicColors.applyToActivityIfAvailable(activity, new DynamicColorsOptions.Builder().setThemeOverlay(theme).build());
    }

    @Deprecated
    public static void applyIfAvailable(@NonNull Activity activity, @NonNull Precondition precondition) {
        DynamicColors.applyToActivityIfAvailable(activity, new DynamicColorsOptions.Builder().setPrecondition(precondition).build());
    }

    public static void applyToActivityIfAvailable(@NonNull Activity activity) {
        DynamicColors.applyToActivityIfAvailable(activity, new DynamicColorsOptions.Builder().build());
    }

    public static void applyToActivityIfAvailable(@NonNull Activity activity, @NonNull DynamicColorsOptions dynamicColorsOptions) {
        DynamicColors.applyToActivityIfAvailable(activity, dynamicColorsOptions.getThemeOverlay(), dynamicColorsOptions.getPrecondition(), dynamicColorsOptions.getOnAppliedCallback());
    }

    private static void applyToActivityIfAvailable(@NonNull Activity activity, @StyleRes int theme, @NonNull Precondition precondition, @NonNull OnAppliedCallback onAppliedCallback) {
        if (!DynamicColors.isDynamicColorAvailable()) {
            return;
        }
        if (theme == 0) {
            theme = DynamicColors.getDefaultThemeOverlay((Context)activity);
        }
        if (theme != 0 && precondition.shouldApplyDynamicColors(activity, theme)) {
            ThemeUtils.applyThemeOverlay((Context)activity, theme);
            onAppliedCallback.onApplied(activity);
        }
    }

    @NonNull
    public static Context wrapContextIfAvailable(@NonNull Context originalContext) {
        return DynamicColors.wrapContextIfAvailable(originalContext, 0);
    }

    @NonNull
    public static Context wrapContextIfAvailable(@NonNull Context originalContext, @StyleRes int theme) {
        if (!DynamicColors.isDynamicColorAvailable()) {
            return originalContext;
        }
        if (theme == 0) {
            theme = DynamicColors.getDefaultThemeOverlay(originalContext);
        }
        return theme == 0 ? originalContext : new ContextThemeWrapper(originalContext, theme);
    }

    @SuppressLint(value={"DefaultLocale"})
    @ChecksSdkIntAtLeast(api=31)
    public static boolean isDynamicColorAvailable() {
        if (Build.VERSION.SDK_INT < 31) {
            return false;
        }
        DeviceSupportCondition deviceSupportCondition = DYNAMIC_COLOR_SUPPORTED_MANUFACTURERS.get(Build.MANUFACTURER.toLowerCase());
        if (deviceSupportCondition == null) {
            deviceSupportCondition = DYNAMIC_COLOR_SUPPORTED_BRANDS.get(Build.BRAND.toLowerCase());
        }
        return deviceSupportCondition != null && deviceSupportCondition.isSupported();
    }

    private static int getDefaultThemeOverlay(@NonNull Context context) {
        TypedArray dynamicColorAttributes = context.obtainStyledAttributes(DYNAMIC_COLOR_THEME_OVERLAY_ATTRIBUTE);
        int theme = dynamicColorAttributes.getResourceId(0, 0);
        dynamicColorAttributes.recycle();
        return theme;
    }

    static {
        HashMap<String, DeviceSupportCondition> deviceMap = new HashMap<String, DeviceSupportCondition>();
        deviceMap.put("google", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("hmd global", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("infinix", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("infinix mobility limited", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("itel", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("kyocera", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("lenovo", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("lge", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("motorola", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("nothing", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("oneplus", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("oppo", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("realme", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("robolectric", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("samsung", SAMSUNG_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("sharp", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("sony", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("tcl", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("tecno", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("tecno mobile limited", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("vivo", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("xiaomi", DEFAULT_DEVICE_SUPPORT_CONDITION);
        DYNAMIC_COLOR_SUPPORTED_MANUFACTURERS = Collections.unmodifiableMap(deviceMap);
        deviceMap = new HashMap();
        deviceMap.put("asus", DEFAULT_DEVICE_SUPPORT_CONDITION);
        deviceMap.put("jio", DEFAULT_DEVICE_SUPPORT_CONDITION);
        DYNAMIC_COLOR_SUPPORTED_BRANDS = Collections.unmodifiableMap(deviceMap);
    }

    private static interface DeviceSupportCondition {
        public boolean isSupported();
    }

    private static class DynamicColorsActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private final DynamicColorsOptions dynamicColorsOptions;

        DynamicColorsActivityLifecycleCallbacks(@NonNull DynamicColorsOptions options) {
            this.dynamicColorsOptions = options;
        }

        public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            DynamicColors.applyToActivityIfAvailable(activity, this.dynamicColorsOptions.getThemeOverlay(), this.dynamicColorsOptions.getPrecondition(), this.dynamicColorsOptions.getOnAppliedCallback());
        }

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }
    }

    public static interface OnAppliedCallback {
        public void onApplied(@NonNull Activity var1);
    }

    public static interface Precondition {
        public boolean shouldApplyDynamicColors(@NonNull Activity var1, @StyleRes int var2);
    }
}

