/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.checkbox;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.CompoundButtonCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialCheckBox
extends AppCompatCheckBox {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_CompoundButton_CheckBox;
    private static final int[][] ENABLED_CHECKED_STATES = new int[][]{{16842910, 0x10100A0}, {16842910, -16842912}, {-16842910, 0x10100A0}, {-16842910, -16842912}};
    @Nullable
    private ColorStateList materialThemeColorsTintList;
    private boolean useMaterialThemeColors;
    private boolean centerIfNoTextEnabled;

    public MaterialCheckBox(Context context) {
        this(context, null);
    }

    public MaterialCheckBox(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.checkboxStyle);
    }

    public MaterialCheckBox(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.MaterialCheckBox, defStyleAttr, DEF_STYLE_RES, new int[0]);
        if (attributes.hasValue(R.styleable.MaterialCheckBox_buttonTint)) {
            CompoundButtonCompat.setButtonTintList((CompoundButton)this, (ColorStateList)MaterialResources.getColorStateList(context, attributes, R.styleable.MaterialCheckBox_buttonTint));
        }
        this.useMaterialThemeColors = attributes.getBoolean(R.styleable.MaterialCheckBox_useMaterialThemeColors, false);
        this.centerIfNoTextEnabled = attributes.getBoolean(R.styleable.MaterialCheckBox_centerIfNoTextEnabled, true);
        attributes.recycle();
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable2;
        if (this.centerIfNoTextEnabled && TextUtils.isEmpty((CharSequence)this.getText()) && (drawable2 = CompoundButtonCompat.getButtonDrawable((CompoundButton)this)) != null) {
            int direction = ViewUtils.isLayoutRtl((View)this) ? -1 : 1;
            int dx = (this.getWidth() - drawable2.getIntrinsicWidth()) / 2 * direction;
            int saveCount = canvas.save();
            canvas.translate((float)dx, 0.0f);
            super.onDraw(canvas);
            canvas.restoreToCount(saveCount);
            if (this.getBackground() != null) {
                Rect bounds = drawable2.getBounds();
                DrawableCompat.setHotspotBounds((Drawable)this.getBackground(), (int)(bounds.left + dx), (int)bounds.top, (int)(bounds.right + dx), (int)bounds.bottom);
            }
            return;
        }
        super.onDraw(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.useMaterialThemeColors && CompoundButtonCompat.getButtonTintList((CompoundButton)this) == null) {
            this.setUseMaterialThemeColors(true);
        }
    }

    public void setUseMaterialThemeColors(boolean useMaterialThemeColors) {
        this.useMaterialThemeColors = useMaterialThemeColors;
        if (useMaterialThemeColors) {
            CompoundButtonCompat.setButtonTintList((CompoundButton)this, (ColorStateList)this.getMaterialThemeColorsTintList());
        } else {
            CompoundButtonCompat.setButtonTintList((CompoundButton)this, null);
        }
    }

    public boolean isUseMaterialThemeColors() {
        return this.useMaterialThemeColors;
    }

    public void setCenterIfNoTextEnabled(boolean centerIfNoTextEnabled) {
        this.centerIfNoTextEnabled = centerIfNoTextEnabled;
    }

    public boolean isCenterIfNoTextEnabled() {
        return this.centerIfNoTextEnabled;
    }

    private ColorStateList getMaterialThemeColorsTintList() {
        if (this.materialThemeColorsTintList == null) {
            int[] checkBoxColorsList = new int[ENABLED_CHECKED_STATES.length];
            int colorControlActivated = MaterialColors.getColor((View)this, R.attr.colorControlActivated);
            int colorSurface = MaterialColors.getColor((View)this, R.attr.colorSurface);
            int colorOnSurface = MaterialColors.getColor((View)this, R.attr.colorOnSurface);
            checkBoxColorsList[0] = MaterialColors.layer(colorSurface, colorControlActivated, 1.0f);
            checkBoxColorsList[1] = MaterialColors.layer(colorSurface, colorOnSurface, 0.54f);
            checkBoxColorsList[2] = MaterialColors.layer(colorSurface, colorOnSurface, 0.38f);
            checkBoxColorsList[3] = MaterialColors.layer(colorSurface, colorOnSurface, 0.38f);
            this.materialThemeColorsTintList = new ColorStateList(ENABLED_CHECKED_STATES, checkBoxColorsList);
        }
        return this.materialThemeColorsTintList;
    }
}

