/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.provider.FontsContractCompat;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class TypefaceCompatUtil {
    private static final String TAG = "TypefaceCompatUtil";
    private static final String CACHE_FILE_PREFIX = ".font";

    private TypefaceCompatUtil() {
    }

    @Nullable
    public static File getTempFile(Context context) {
        File cacheDir = context.getCacheDir();
        if (cacheDir == null) {
            return null;
        }
        String prefix = CACHE_FILE_PREFIX + Process.myPid() + "-" + Process.myTid() + "-";
        for (int i = 0; i < 100; ++i) {
            File file = new File(cacheDir, prefix + i);
            try {
                if (!file.createNewFile()) continue;
                return file;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    @RequiresApi(value=19)
    private static ByteBuffer mmap(File file) {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream fis = new FileInputStream(file);
        try {
            FileChannel channel = fis.getChannel();
            long size = channel.size();
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        fis.close();
        return mappedByteBuffer;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @RequiresApi(value=19)
    public static ByteBuffer mmap(Context context, CancellationSignal cancellationSignal, Uri uri) {
        ContentResolver resolver = context.getContentResolver();
        try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(uri, "r", cancellationSignal);){
            MappedByteBuffer mappedByteBuffer;
            if (pfd == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            try (FileInputStream fis = new FileInputStream(pfd.getFileDescriptor());){
                FileChannel channel = fis.getChannel();
                long size = channel.size();
                mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            }
            return mappedByteBuffer;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @RequiresApi(value=19)
    public static ByteBuffer copyToDirectBuffer(Context context, Resources res, int id2) {
        File tmpFile = TypefaceCompatUtil.getTempFile(context);
        if (tmpFile == null) {
            return null;
        }
        try {
            if (!TypefaceCompatUtil.copyToFile(tmpFile, res, id2)) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = TypefaceCompatUtil.mmap(tmpFile);
            return byteBuffer;
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyToFile(File file, InputStream is) {
        boolean bl;
        FileOutputStream os = null;
        StrictMode.ThreadPolicy old = StrictMode.allowThreadDiskWrites();
        try {
            int readLen;
            os = new FileOutputStream(file, false);
            byte[] buffer = new byte[1024];
            while ((readLen = is.read(buffer)) != -1) {
                os.write(buffer, 0, readLen);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                Log.e((String)TAG, (String)("Error copying resource contents to temp file: " + e.getMessage()));
                bl2 = false;
            }
            catch (Throwable throwable) {
                TypefaceCompatUtil.closeQuietly(os);
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)old);
                throw throwable;
            }
            TypefaceCompatUtil.closeQuietly(os);
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)old);
            return bl2;
        }
        TypefaceCompatUtil.closeQuietly(os);
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)old);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyToFile(File file, Resources res, int id2) {
        InputStream is = null;
        try {
            is = res.openRawResource(id2);
            boolean bl = TypefaceCompatUtil.copyToFile(file, is);
            return bl;
        }
        finally {
            TypefaceCompatUtil.closeQuietly(is);
        }
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    @RequiresApi(value=19)
    public static Map<Uri, ByteBuffer> readFontInfoIntoByteBuffer(@NonNull Context context, @NonNull FontsContractCompat.FontInfo[] fonts, @Nullable CancellationSignal cancellationSignal) {
        HashMap<Uri, ByteBuffer> out = new HashMap<Uri, ByteBuffer>();
        for (FontsContractCompat.FontInfo font : fonts) {
            Uri uri;
            if (font.getResultCode() != 0 || out.containsKey(uri = font.getUri())) continue;
            ByteBuffer buffer = TypefaceCompatUtil.mmap(context, cancellationSignal, uri);
            out.put(uri, buffer);
        }
        return Collections.unmodifiableMap(out);
    }
}

