/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.signature;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Key;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class MediaStoreSignature
implements Key {
    @NonNull
    private final String mimeType;
    private final long dateModified;
    private final int orientation;

    public MediaStoreSignature(@Nullable String mimeType, long dateModified, int orientation) {
        this.mimeType = mimeType == null ? "" : mimeType;
        this.dateModified = dateModified;
        this.orientation = orientation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaStoreSignature that = (MediaStoreSignature)o;
        if (this.dateModified != that.dateModified) {
            return false;
        }
        if (this.orientation != that.orientation) {
            return false;
        }
        return this.mimeType.equals(that.mimeType);
    }

    @Override
    public int hashCode() {
        int result = this.mimeType.hashCode();
        result = 31 * result + (int)(this.dateModified ^ this.dateModified >>> 32);
        result = 31 * result + this.orientation;
        return result;
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        byte[] data = ByteBuffer.allocate(12).putLong(this.dateModified).putInt(this.orientation).array();
        messageDigest.update(data);
        messageDigest.update(this.mimeType.getBytes(CHARSET));
    }
}

