/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.util.Log;
import com.google.crypto.tink.Aead;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.ProviderException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public final class AndroidKeystoreAesGcm
implements Aead {
    private static final String TAG = AndroidKeystoreAesGcm.class.getSimpleName();
    private static final int MAX_WAIT_TIME_MILLISECONDS_BEFORE_RETRY = 100;
    private static final int IV_SIZE_IN_BYTES = 12;
    private static final int TAG_SIZE_IN_BYTES = 16;
    private final SecretKey key;

    public AndroidKeystoreAesGcm(String keyId) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        this.key = (SecretKey)keyStore.getKey(keyId, null);
        if (this.key == null) {
            throw new InvalidKeyException("Keystore cannot load the key with ID: " + keyId);
        }
    }

    AndroidKeystoreAesGcm(String keyId, KeyStore keyStore) throws GeneralSecurityException {
        this.key = (SecretKey)keyStore.getKey(keyId, null);
        if (this.key == null) {
            throw new InvalidKeyException("Keystore cannot load the key with ID: " + keyId);
        }
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] aad) throws GeneralSecurityException {
        try {
            return this.encryptInternal(plaintext, aad);
        }
        catch (GeneralSecurityException | ProviderException ex) {
            Log.w((String)TAG, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)ex);
            AndroidKeystoreAesGcm.sleep();
            return this.encryptInternal(plaintext, aad);
        }
    }

    private byte[] encryptInternal(byte[] plaintext, byte[] aad) throws GeneralSecurityException {
        if (plaintext.length > 2147483619) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] ciphertext = new byte[12 + plaintext.length + 16];
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, this.key);
        cipher.updateAAD(aad);
        int unusedWritten = cipher.doFinal(plaintext, 0, plaintext.length, ciphertext, 12);
        System.arraycopy(cipher.getIV(), 0, ciphertext, 0, 12);
        return ciphertext;
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] aad) throws GeneralSecurityException {
        try {
            return this.decryptInternal(ciphertext, aad);
        }
        catch (GeneralSecurityException | ProviderException ex) {
            Log.w((String)TAG, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)ex);
            AndroidKeystoreAesGcm.sleep();
            return this.decryptInternal(ciphertext, aad);
        }
    }

    private byte[] decryptInternal(byte[] ciphertext, byte[] aad) throws GeneralSecurityException {
        if (ciphertext.length < 28) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        GCMParameterSpec params = new GCMParameterSpec(128, ciphertext, 0, 12);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)this.key, params);
        cipher.updateAAD(aad);
        return cipher.doFinal(ciphertext, 12, ciphertext.length - 12);
    }

    private static void sleep() {
        int waitTimeMillis = (int)(Math.random() * 100.0);
        try {
            Thread.sleep(waitTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

