/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.MotionLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.CharBuffer;

@SuppressLint(value={"LogConditional"})
public class Debug {
    public static void logStack(String tag, String msg, int n) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        String s = " ";
        n = Math.min(n, st.length - 1);
        for (int i = 1; i <= n; ++i) {
            StackTraceElement ste = st[i];
            String stack = ".(" + st[i].getFileName() + ":" + st[i].getLineNumber() + ") " + st[i].getMethodName();
            s = s + " ";
            Log.v((String)tag, (String)(msg + s + stack + s));
        }
    }

    public static void printStack(String msg, int n) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        String s = " ";
        n = Math.min(n, st.length - 1);
        for (int i = 1; i <= n; ++i) {
            StackTraceElement ste = st[i];
            String stack = ".(" + st[i].getFileName() + ":" + st[i].getLineNumber() + ") ";
            s = s + " ";
            System.out.println(msg + s + stack + s);
        }
    }

    public static String getName(View view) {
        try {
            Context context = view.getContext();
            return context.getResources().getResourceEntryName(view.getId());
        }
        catch (Exception ex) {
            return "UNKNOWN";
        }
    }

    public static void dumpPoc(Object obj) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        String loc = ".(" + s.getFileName() + ":" + s.getLineNumber() + ")";
        Class<?> c = obj.getClass();
        System.out.println(loc + "------------- " + c.getName() + " --------------------");
        Field[] declaredFields = c.getFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field declaredField = declaredFields[i];
            try {
                Object value = declaredField.get(obj);
                if (!declaredField.getName().startsWith("layout_constraint") || value instanceof Integer && value.toString().equals("-1") || value instanceof Integer && value.toString().equals("0") || value instanceof Float && value.toString().equals("1.0") || value instanceof Float && value.toString().equals("0.5")) continue;
                System.out.println(loc + "    " + declaredField.getName() + " " + value);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        System.out.println(loc + "------------- " + c.getSimpleName() + " --------------------");
    }

    public static String getName(Context context, int id2) {
        try {
            if (id2 != -1) {
                return context.getResources().getResourceEntryName(id2);
            }
            return "UNKNOWN";
        }
        catch (Exception ex) {
            return "?" + id2;
        }
    }

    public static String getName(Context context, int[] id2) {
        try {
            String str = id2.length + "[";
            for (int i = 0; i < id2.length; ++i) {
                str = str + (i == 0 ? "" : " ");
                String tmp = null;
                try {
                    tmp = context.getResources().getResourceEntryName(id2[i]);
                }
                catch (Resources.NotFoundException e) {
                    tmp = "? " + id2[i] + " ";
                }
                str = str + tmp;
            }
            return str + "]";
        }
        catch (Exception ex) {
            Log.v((String)"DEBUG", (String)ex.toString());
            return "UNKNOWN";
        }
    }

    public static String getState(MotionLayout layout, int stateId) {
        return Debug.getState(layout, stateId, -1);
    }

    public static String getState(MotionLayout layout, int stateId, int len) {
        if (stateId == -1) {
            return "UNDEFINED";
        }
        Context context = layout.getContext();
        String str = context.getResources().getResourceEntryName(stateId);
        if (len != -1) {
            int n;
            if (str.length() > len) {
                str = str.replaceAll("([^_])[aeiou]+", "$1");
            }
            if (str.length() > len && (n = str.replaceAll("[^_]", "").length()) > 0) {
                int extra = (str.length() - len) / n;
                String reg = CharBuffer.allocate(extra).toString().replace('\u0000', '.') + "_";
                str = str.replaceAll(reg, "_");
            }
        }
        return str;
    }

    public static String getActionType(MotionEvent event) {
        int type = event.getAction();
        Field[] fields = MotionEvent.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || field.getInt(null) != type) continue;
                return field.getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return "---";
    }

    public static String getLocation() {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        return ".(" + s.getFileName() + ":" + s.getLineNumber() + ")";
    }

    public static String getLoc() {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        return ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + s.getMethodName() + "()";
    }

    public static String getLocation2() {
        StackTraceElement s = new Throwable().getStackTrace()[2];
        return ".(" + s.getFileName() + ":" + s.getLineNumber() + ")";
    }

    public static String getCallFrom(int n) {
        StackTraceElement s = new Throwable().getStackTrace()[2 + n];
        return ".(" + s.getFileName() + ":" + s.getLineNumber() + ")";
    }

    public static void dumpLayoutParams(ViewGroup layout, String str) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        String loc = ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + str + "  ";
        int n = layout.getChildCount();
        System.out.println(str + " children " + n);
        for (int i = 0; i < n; ++i) {
            View v = layout.getChildAt(i);
            System.out.println(loc + "     " + Debug.getName(v));
            ViewGroup.LayoutParams param = v.getLayoutParams();
            Field[] declaredFields = param.getClass().getFields();
            for (int k = 0; k < declaredFields.length; ++k) {
                Field declaredField = declaredFields[k];
                try {
                    Object value = declaredField.get(param);
                    String name = declaredField.getName();
                    if (!name.contains("To") || value.toString().equals("-1")) continue;
                    System.out.println(loc + "       " + declaredField.getName() + " " + value);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public static void dumpLayoutParams(ViewGroup.LayoutParams param, String str) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        String loc = ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + str + "  ";
        System.out.println(" >>>>>>>>>>>>>>>>>>. dump " + loc + "  " + param.getClass().getName());
        Field[] declaredFields = param.getClass().getFields();
        for (int k = 0; k < declaredFields.length; ++k) {
            Field declaredField = declaredFields[k];
            try {
                Object value = declaredField.get(param);
                String name = declaredField.getName();
                if (!name.contains("To") || value.toString().equals("-1")) continue;
                System.out.println(loc + "       " + name + " " + value);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        System.out.println(" <<<<<<<<<<<<<<<<< dump " + loc);
    }
}

