/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app.strictmode;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.strictmode.FragmentReuseViolation;
import androidx.fragment.app.strictmode.FragmentTagUsageViolation;
import androidx.fragment.app.strictmode.GetRetainInstanceUsageViolation;
import androidx.fragment.app.strictmode.GetTargetFragmentRequestCodeUsageViolation;
import androidx.fragment.app.strictmode.GetTargetFragmentUsageViolation;
import androidx.fragment.app.strictmode.SetRetainInstanceUsageViolation;
import androidx.fragment.app.strictmode.SetTargetFragmentUsageViolation;
import androidx.fragment.app.strictmode.SetUserVisibleHintViolation;
import androidx.fragment.app.strictmode.Violation;
import androidx.fragment.app.strictmode.WrongFragmentContainerViolation;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003./0B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u001a\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0007J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0002J0\u0010*\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u00062\u000e\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0,2\u000e\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u00061"}, d2={"Landroidx/fragment/app/strictmode/FragmentStrictMode;", "", "()V", "TAG", "", "defaultPolicy", "Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy;", "getDefaultPolicy", "()Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy;", "setDefaultPolicy", "(Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy;)V", "getNearestPolicy", "fragment", "Landroidx/fragment/app/Fragment;", "handlePolicyViolation", "", "policy", "violation", "Landroidx/fragment/app/strictmode/Violation;", "logIfDebuggingEnabled", "onFragmentReuse", "previousFragmentId", "onFragmentTagUsage", "container", "Landroid/view/ViewGroup;", "onGetRetainInstanceUsage", "onGetTargetFragmentRequestCodeUsage", "onGetTargetFragmentUsage", "onPolicyViolation", "onSetRetainInstanceUsage", "onSetTargetFragmentUsage", "violatingFragment", "targetFragment", "requestCode", "", "onSetUserVisibleHint", "isVisibleToUser", "", "onWrongFragmentContainer", "runOnHostThread", "runnable", "Ljava/lang/Runnable;", "shouldHandlePolicyViolation", "fragmentClass", "Ljava/lang/Class;", "violationClass", "Flag", "OnViolationListener", "Policy", "fragment_release"})
public final class FragmentStrictMode {
    @NotNull
    public static final FragmentStrictMode INSTANCE = new FragmentStrictMode();
    @NotNull
    private static final String TAG = "FragmentStrictMode";
    @NotNull
    private static Policy defaultPolicy = Policy.LAX;

    private FragmentStrictMode() {
    }

    @NotNull
    public final Policy getDefaultPolicy() {
        return defaultPolicy;
    }

    public final void setDefaultPolicy(@NotNull Policy policy) {
        Intrinsics.checkNotNullParameter((Object)policy, (String)"<set-?>");
        defaultPolicy = policy;
    }

    private final Policy getNearestPolicy(Fragment fragment) {
        for (Fragment declaringFragment = fragment; declaringFragment != null; declaringFragment = declaringFragment.getParentFragment()) {
            if (!declaringFragment.isAdded()) continue;
            Object object = declaringFragment.getParentFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"declaringFragment.parentFragmentManager");
            FragmentManager fragmentManager = object;
            if (fragmentManager.getStrictModePolicy() == null) continue;
            Policy policy = fragmentManager.getStrictModePolicy();
            Intrinsics.checkNotNull((Object)policy);
            object = policy;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fragmentManager.strictModePolicy!!");
            return object;
        }
        return defaultPolicy;
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onFragmentReuse(@NotNull Fragment fragment, @NotNull String previousFragmentId) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)previousFragmentId, (String)"previousFragmentId");
        Violation violation = new FragmentReuseViolation(fragment, previousFragmentId);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_FRAGMENT_REUSE) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onFragmentTagUsage(@NotNull Fragment fragment, @Nullable ViewGroup container) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Violation violation = new FragmentTagUsageViolation(fragment, container);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_FRAGMENT_TAG_USAGE) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onSetRetainInstanceUsage(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Violation violation = new SetRetainInstanceUsageViolation(fragment);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_RETAIN_INSTANCE_USAGE) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onGetRetainInstanceUsage(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Violation violation = new GetRetainInstanceUsageViolation(fragment);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_RETAIN_INSTANCE_USAGE) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onSetUserVisibleHint(@NotNull Fragment fragment, boolean isVisibleToUser) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Violation violation = new SetUserVisibleHintViolation(fragment, isVisibleToUser);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_SET_USER_VISIBLE_HINT) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onSetTargetFragmentUsage(@NotNull Fragment violatingFragment, @NotNull Fragment targetFragment, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)violatingFragment, (String)"violatingFragment");
        Intrinsics.checkNotNullParameter((Object)targetFragment, (String)"targetFragment");
        Violation violation = new SetTargetFragmentUsageViolation(violatingFragment, targetFragment, requestCode);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(violatingFragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_TARGET_FRAGMENT_USAGE) && INSTANCE.shouldHandlePolicyViolation(policy, violatingFragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onGetTargetFragmentUsage(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Violation violation = new GetTargetFragmentUsageViolation(fragment);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_TARGET_FRAGMENT_USAGE) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onGetTargetFragmentRequestCodeUsage(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Violation violation = new GetTargetFragmentRequestCodeUsageViolation(fragment);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_TARGET_FRAGMENT_USAGE) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final void onWrongFragmentContainer(@NotNull Fragment fragment, @NotNull ViewGroup container) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Violation violation = new WrongFragmentContainerViolation(fragment, container);
        INSTANCE.logIfDebuggingEnabled(violation);
        Policy policy = INSTANCE.getNearestPolicy(fragment);
        if (policy.getFlags$fragment_release().contains((Object)Flag.DETECT_WRONG_FRAGMENT_CONTAINER) && INSTANCE.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            INSTANCE.handlePolicyViolation(policy, violation);
        }
    }

    @VisibleForTesting
    public final void onPolicyViolation(@NotNull Violation violation) {
        Intrinsics.checkNotNullParameter((Object)violation, (String)"violation");
        this.logIfDebuggingEnabled(violation);
        Fragment fragment = violation.getFragment();
        Policy policy = this.getNearestPolicy(fragment);
        if (this.shouldHandlePolicyViolation(policy, fragment.getClass(), violation.getClass())) {
            this.handlePolicyViolation(policy, violation);
        }
    }

    private final void logIfDebuggingEnabled(Violation violation) {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)"FragmentManager", (String)Intrinsics.stringPlus((String)"StrictMode violation in ", (Object)violation.getFragment().getClass().getName()), (Throwable)violation);
        }
    }

    private final boolean shouldHandlePolicyViolation(Policy policy, Class<? extends Fragment> fragmentClass, Class<? extends Violation> violationClass) {
        Set<Class<? extends Violation>> set = policy.getMAllowedViolations$fragment_release().get(fragmentClass);
        if (set == null) {
            return true;
        }
        Set<Class<? extends Violation>> violationsToBypass = set;
        if (!Intrinsics.areEqual(violationClass.getSuperclass(), Violation.class) && CollectionsKt.contains((Iterable)violationsToBypass, violationClass.getSuperclass())) {
            return false;
        }
        return !violationsToBypass.contains(violationClass);
    }

    private final void handlePolicyViolation(Policy policy, Violation violation) {
        Fragment fragment = violation.getFragment();
        String fragmentName = fragment.getClass().getName();
        if (policy.getFlags$fragment_release().contains((Object)Flag.PENALTY_LOG)) {
            Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Policy violation in ", (Object)fragmentName), (Throwable)violation);
        }
        if (policy.getListener$fragment_release() != null) {
            this.runOnHostThread(fragment, () -> FragmentStrictMode.handlePolicyViolation$lambda-0(policy, violation));
        }
        if (policy.getFlags$fragment_release().contains((Object)Flag.PENALTY_DEATH)) {
            this.runOnHostThread(fragment, () -> FragmentStrictMode.handlePolicyViolation$lambda-1(fragmentName, violation));
        }
    }

    private final void runOnHostThread(Fragment fragment, Runnable runnable) {
        if (fragment.isAdded()) {
            Handler handler = fragment.getParentFragmentManager().getHost().getHandler();
            Intrinsics.checkNotNullExpressionValue((Object)handler, (String)"fragment.parentFragmentManager.host.handler");
            Handler handler2 = handler;
            if (Intrinsics.areEqual((Object)handler2.getLooper(), (Object)Looper.myLooper())) {
                runnable.run();
            } else {
                handler2.post(runnable);
            }
        } else {
            runnable.run();
        }
    }

    private static final void handlePolicyViolation$lambda-0(Policy $policy, Violation $violation) {
        Intrinsics.checkNotNullParameter((Object)$policy, (String)"$policy");
        Intrinsics.checkNotNullParameter((Object)$violation, (String)"$violation");
        $policy.getListener$fragment_release().onViolation($violation);
    }

    private static final void handlePolicyViolation$lambda-1(String $fragmentName, Violation $violation) {
        Intrinsics.checkNotNullParameter((Object)$violation, (String)"$violation");
        Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Policy violation with PENALTY_DEATH in ", (Object)$fragmentName), (Throwable)$violation);
        throw $violation;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Landroidx/fragment/app/strictmode/FragmentStrictMode$Flag;", "", "(Ljava/lang/String;I)V", "PENALTY_LOG", "PENALTY_DEATH", "DETECT_FRAGMENT_REUSE", "DETECT_FRAGMENT_TAG_USAGE", "DETECT_RETAIN_INSTANCE_USAGE", "DETECT_SET_USER_VISIBLE_HINT", "DETECT_TARGET_FRAGMENT_USAGE", "DETECT_WRONG_FRAGMENT_CONTAINER", "fragment_release"})
    public static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag PENALTY_LOG = new Flag();
        public static final /* enum */ Flag PENALTY_DEATH = new Flag();
        public static final /* enum */ Flag DETECT_FRAGMENT_REUSE = new Flag();
        public static final /* enum */ Flag DETECT_FRAGMENT_TAG_USAGE = new Flag();
        public static final /* enum */ Flag DETECT_RETAIN_INSTANCE_USAGE = new Flag();
        public static final /* enum */ Flag DETECT_SET_USER_VISIBLE_HINT = new Flag();
        public static final /* enum */ Flag DETECT_TARGET_FRAGMENT_USAGE = new Flag();
        public static final /* enum */ Flag DETECT_WRONG_FRAGMENT_CONTAINER = new Flag();
        private static final /* synthetic */ Flag[] $VALUES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String value) {
            return Enum.valueOf(Flag.class, value);
        }

        static {
            $VALUES = flagArray = new Flag[]{Flag.PENALTY_LOG, Flag.PENALTY_DEATH, Flag.DETECT_FRAGMENT_REUSE, Flag.DETECT_FRAGMENT_TAG_USAGE, Flag.DETECT_RETAIN_INSTANCE_USAGE, Flag.DETECT_SET_USER_VISIBLE_HINT, Flag.DETECT_TARGET_FRAGMENT_USAGE, Flag.DETECT_WRONG_FRAGMENT_CONTAINER};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Landroidx/fragment/app/strictmode/FragmentStrictMode$OnViolationListener;", "", "onViolation", "", "violation", "Landroidx/fragment/app/strictmode/Violation;", "fragment_release"})
    public static interface OnViolationListener {
        public void onViolation(@NotNull Violation var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016BI\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012(\u0010\u0007\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\t0\u000b0\b\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R6\u0010\u0012\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\t0\u00030\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy;", "", "flags", "", "Landroidx/fragment/app/strictmode/FragmentStrictMode$Flag;", "listener", "Landroidx/fragment/app/strictmode/FragmentStrictMode$OnViolationListener;", "allowedViolations", "", "Ljava/lang/Class;", "Landroidx/fragment/app/Fragment;", "", "Landroidx/fragment/app/strictmode/Violation;", "(Ljava/util/Set;Landroidx/fragment/app/strictmode/FragmentStrictMode$OnViolationListener;Ljava/util/Map;)V", "getFlags$fragment_release", "()Ljava/util/Set;", "getListener$fragment_release", "()Landroidx/fragment/app/strictmode/FragmentStrictMode$OnViolationListener;", "mAllowedViolations", "getMAllowedViolations$fragment_release", "()Ljava/util/Map;", "Builder", "Companion", "fragment_release"})
    public static final class Policy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<Flag> flags;
        @Nullable
        private final OnViolationListener listener;
        @NotNull
        private final Map<Class<? extends Fragment>, Set<Class<? extends Violation>>> mAllowedViolations;
        @JvmField
        @NotNull
        public static final Policy LAX = new Policy(SetsKt.emptySet(), null, MapsKt.emptyMap());

        public Policy(@NotNull Set<? extends Flag> flags, @Nullable OnViolationListener listener, @NotNull Map<Class<? extends Fragment>, ? extends Set<Class<? extends Violation>>> allowedViolations) {
            Intrinsics.checkNotNullParameter(flags, (String)"flags");
            Intrinsics.checkNotNullParameter(allowedViolations, (String)"allowedViolations");
            this.flags = flags;
            this.listener = listener;
            boolean bl = false;
            Map newAllowedViolationsMap = new LinkedHashMap();
            Object object = allowedViolations;
            boolean bl2 = false;
            Iterator<Map.Entry<Class<? extends Fragment>, ? extends Set<Class<? extends Violation>>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl3 = false;
                Class key = (Class)object2.getKey();
                Object object3 = object;
                boolean bl4 = false;
                Set value = (Set)object3.getValue();
                object3 = newAllowedViolationsMap;
                bl4 = false;
                object3.put(key, value);
            }
            this.mAllowedViolations = newAllowedViolationsMap;
        }

        @NotNull
        public final Set<Flag> getFlags$fragment_release() {
            return this.flags;
        }

        @Nullable
        public final OnViolationListener getListener$fragment_release() {
            return this.listener;
        }

        @NotNull
        public final Map<Class<? extends Fragment>, Set<Class<? extends Violation>>> getMAllowedViolations$fragment_release() {
            return this.mAllowedViolations;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u00020\u00002\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\nH\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0000H\u0007J\b\u0010\u0013\u001a\u00020\u0000H\u0007J\b\u0010\u0014\u001a\u00020\u0000H\u0007J\b\u0010\u0015\u001a\u00020\u0000H\u0007J\b\u0010\u0016\u001a\u00020\u0000H\u0007J\b\u0010\u0017\u001a\u00020\u0000H\u0007J\b\u0010\u0018\u001a\u00020\u0000H\u0007J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\u001a\u001a\u00020\u0000H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\b\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\n0\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy$Builder;", "", "()V", "flags", "", "Landroidx/fragment/app/strictmode/FragmentStrictMode$Flag;", "listener", "Landroidx/fragment/app/strictmode/FragmentStrictMode$OnViolationListener;", "mAllowedViolations", "", "Ljava/lang/Class;", "Landroidx/fragment/app/Fragment;", "Landroidx/fragment/app/strictmode/Violation;", "allowViolation", "fragmentClass", "violationClass", "build", "Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy;", "detectFragmentReuse", "detectFragmentTagUsage", "detectRetainInstanceUsage", "detectSetUserVisibleHint", "detectTargetFragmentUsage", "detectWrongFragmentContainer", "penaltyDeath", "penaltyListener", "penaltyLog", "fragment_release"})
        public static final class Builder {
            @NotNull
            private final Set<Flag> flags;
            @Nullable
            private OnViolationListener listener;
            @NotNull
            private final Map<Class<? extends Fragment>, Set<Class<? extends Violation>>> mAllowedViolations;

            public Builder() {
                boolean bl = false;
                this.flags = new LinkedHashSet();
                bl = false;
                this.mAllowedViolations = new LinkedHashMap();
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder penaltyLog() {
                this.flags.add(Flag.PENALTY_LOG);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder penaltyDeath() {
                this.flags.add(Flag.PENALTY_DEATH);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder penaltyListener(@NotNull OnViolationListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                this.listener = listener;
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder detectFragmentReuse() {
                this.flags.add(Flag.DETECT_FRAGMENT_REUSE);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder detectFragmentTagUsage() {
                this.flags.add(Flag.DETECT_FRAGMENT_TAG_USAGE);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder detectRetainInstanceUsage() {
                this.flags.add(Flag.DETECT_RETAIN_INSTANCE_USAGE);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder detectSetUserVisibleHint() {
                this.flags.add(Flag.DETECT_SET_USER_VISIBLE_HINT);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder detectTargetFragmentUsage() {
                this.flags.add(Flag.DETECT_TARGET_FRAGMENT_USAGE);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder detectWrongFragmentContainer() {
                this.flags.add(Flag.DETECT_WRONG_FRAGMENT_CONTAINER);
                return this;
            }

            @SuppressLint(value={"BuilderSetStyle"})
            @NotNull
            public final Builder allowViolation(@NotNull Class<? extends Fragment> fragmentClass, @NotNull Class<? extends Violation> violationClass) {
                Intrinsics.checkNotNullParameter(fragmentClass, (String)"fragmentClass");
                Intrinsics.checkNotNullParameter(violationClass, (String)"violationClass");
                Set violationsToBypass = this.mAllowedViolations.get(fragmentClass);
                if (violationsToBypass == null) {
                    boolean bl = false;
                    violationsToBypass = new LinkedHashSet();
                }
                violationsToBypass.add(violationClass);
                Map<Class<? extends Fragment>, Set<Class<? extends Violation>>> map = this.mAllowedViolations;
                boolean bl = false;
                map.put(fragmentClass, violationsToBypass);
                return this;
            }

            @NotNull
            public final Policy build() {
                if (this.listener == null && !this.flags.contains((Object)Flag.PENALTY_DEATH)) {
                    this.penaltyLog();
                }
                return new Policy(this.flags, this.listener, this.mAllowedViolations);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy$Companion;", "", "()V", "LAX", "Landroidx/fragment/app/strictmode/FragmentStrictMode$Policy;", "fragment_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

