/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassifier;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;

final class AppCompatTextClassifierHelper {
    @NonNull
    private TextView mTextView;
    @Nullable
    private TextClassifier mTextClassifier;

    AppCompatTextClassifierHelper(@NonNull TextView textView) {
        this.mTextView = (TextView)Preconditions.checkNotNull((Object)textView);
    }

    @RequiresApi(api=26)
    public void setTextClassifier(@Nullable TextClassifier textClassifier) {
        this.mTextClassifier = textClassifier;
    }

    @RequiresApi(api=26)
    @NonNull
    public TextClassifier getTextClassifier() {
        if (this.mTextClassifier == null) {
            TextClassificationManager tcm = (TextClassificationManager)this.mTextView.getContext().getSystemService(TextClassificationManager.class);
            if (tcm != null) {
                return tcm.getTextClassifier();
            }
            return TextClassifier.NO_OP;
        }
        return this.mTextClassifier;
    }
}

