/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.RectF;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.google.android.material.shape.CornerSize;
import java.util.Arrays;

public final class RelativeCornerSize
implements CornerSize {
    private final float percent;

    public RelativeCornerSize(@FloatRange(from=0.0, to=1.0) float percent) {
        this.percent = percent;
    }

    @FloatRange(from=0.0, to=1.0)
    public float getRelativePercent() {
        return this.percent;
    }

    @Override
    public float getCornerSize(@NonNull RectF bounds) {
        return this.percent * bounds.height();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelativeCornerSize)) {
            return false;
        }
        RelativeCornerSize that = (RelativeCornerSize)o;
        return this.percent == that.percent;
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{Float.valueOf(this.percent)};
        return Arrays.hashCode(hashedFields);
    }
}

