/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import androidx.annotation.AnimRes;
import androidx.annotation.NonNull;
import androidx.core.view.OneShotPreDrawListener;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;

class FragmentAnim {
    private FragmentAnim() {
    }

    static AnimationOrAnimator loadAnimation(@NonNull Context context, @NonNull Fragment fragment, boolean enter, boolean isPop) {
        block16: {
            int transit = fragment.getNextTransition();
            int nextAnim = FragmentAnim.getNextAnim(fragment, enter, isPop);
            fragment.setAnimations(0, 0, 0, 0);
            if (fragment.mContainer != null && fragment.mContainer.getTag(R.id.visible_removing_fragment_view_tag) != null) {
                fragment.mContainer.setTag(R.id.visible_removing_fragment_view_tag, null);
            }
            if (fragment.mContainer != null && fragment.mContainer.getLayoutTransition() != null) {
                return null;
            }
            Animation animation = fragment.onCreateAnimation(transit, enter, nextAnim);
            if (animation != null) {
                return new AnimationOrAnimator(animation);
            }
            Animator animator2 = fragment.onCreateAnimator(transit, enter, nextAnim);
            if (animator2 != null) {
                return new AnimationOrAnimator(animator2);
            }
            if (nextAnim == 0 && transit != 0) {
                nextAnim = FragmentAnim.transitToAnimResourceId(context, transit, enter);
            }
            if (nextAnim != 0) {
                String dir = context.getResources().getResourceTypeName(nextAnim);
                boolean isAnim = "anim".equals(dir);
                boolean successfulLoad = false;
                if (isAnim) {
                    try {
                        animation = AnimationUtils.loadAnimation((Context)context, (int)nextAnim);
                        if (animation != null) {
                            return new AnimationOrAnimator(animation);
                        }
                        successfulLoad = true;
                    }
                    catch (Resources.NotFoundException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (!successfulLoad) {
                    try {
                        animator2 = AnimatorInflater.loadAnimator((Context)context, (int)nextAnim);
                        if (animator2 != null) {
                            return new AnimationOrAnimator(animator2);
                        }
                    }
                    catch (RuntimeException e) {
                        if (isAnim) {
                            throw e;
                        }
                        animation = AnimationUtils.loadAnimation((Context)context, (int)nextAnim);
                        if (animation == null) break block16;
                        return new AnimationOrAnimator(animation);
                    }
                }
            }
        }
        return null;
    }

    @AnimRes
    private static int getNextAnim(Fragment fragment, boolean enter, boolean isPop) {
        if (isPop) {
            if (enter) {
                return fragment.getPopEnterAnim();
            }
            return fragment.getPopExitAnim();
        }
        if (enter) {
            return fragment.getEnterAnim();
        }
        return fragment.getExitAnim();
    }

    @AnimRes
    private static int transitToAnimResourceId(@NonNull Context context, int transit, boolean enter) {
        int animAttr = -1;
        switch (transit) {
            case 4097: {
                animAttr = enter ? R.animator.fragment_open_enter : R.animator.fragment_open_exit;
                break;
            }
            case 8194: {
                animAttr = enter ? R.animator.fragment_close_enter : R.animator.fragment_close_exit;
                break;
            }
            case 4099: {
                animAttr = enter ? R.animator.fragment_fade_enter : R.animator.fragment_fade_exit;
                break;
            }
            case 4100: {
                animAttr = enter ? FragmentAnim.toActivityTransitResId(context, 16842936) : FragmentAnim.toActivityTransitResId(context, 16842937);
                break;
            }
            case 8197: {
                animAttr = enter ? FragmentAnim.toActivityTransitResId(context, 16842938) : FragmentAnim.toActivityTransitResId(context, 0x10100BB);
            }
        }
        return animAttr;
    }

    @AnimRes
    private static int toActivityTransitResId(@NonNull Context context, int attrInt) {
        TypedArray typedArray = context.obtainStyledAttributes(0x1030001, new int[]{attrInt});
        int resId = typedArray.getResourceId(0, -1);
        typedArray.recycle();
        return resId;
    }

    static class EndViewTransitionAnimation
    extends AnimationSet
    implements Runnable {
        private final ViewGroup mParent;
        private final View mChild;
        private boolean mEnded;
        private boolean mTransitionEnded;
        private boolean mAnimating = true;

        EndViewTransitionAnimation(@NonNull Animation animation, @NonNull ViewGroup parent, @NonNull View child) {
            super(false);
            this.mParent = parent;
            this.mChild = child;
            this.addAnimation(animation);
            this.mParent.post((Runnable)this);
        }

        public boolean getTransformation(long currentTime, @NonNull Transformation t) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, t);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        public boolean getTransformation(long currentTime, @NonNull Transformation outTransformation, float scale) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, outTransformation, scale);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        @Override
        public void run() {
            if (!this.mEnded && this.mAnimating) {
                this.mAnimating = false;
                this.mParent.post((Runnable)this);
            } else {
                this.mParent.endViewTransition(this.mChild);
                this.mTransitionEnded = true;
            }
        }
    }

    static class AnimationOrAnimator {
        public final Animation animation;
        public final Animator animator;

        AnimationOrAnimator(Animation animation) {
            this.animation = animation;
            this.animator = null;
            if (animation == null) {
                throw new IllegalStateException("Animation cannot be null");
            }
        }

        AnimationOrAnimator(Animator animator2) {
            this.animation = null;
            this.animator = animator2;
            if (animator2 == null) {
                throw new IllegalStateException("Animator cannot be null");
            }
        }
    }
}

