#!/usr/bin/perl -w

use strict;

# Przykad dla podrozdziau "Operowanie na tekcie".
# Odczutuje ze standardowego wejcia plik zawierajcy:
#
#  1. wiersz:  nazwa
#  2. wiersz:  staa1
#  3. wiersz:  staa2
#    :           :
#
# Generuje plik nazwa.h, zawierajcy:
#
#   |extern const char* NAZWA_names[];
#   |typedef enum {
#   |   staa1,
#   |   staa2,
#   |     :
#   | } NAZWA;
#
# oraz plik nazwa.c zawierajcy:
#
#   | const char* NAZWA_names[] = {
#   |   "staa1",
#   |   "staa2",
#   | };
#
# Plik nagwki powinien by doczany do standardowego kodu.
# Takie rozwizanie umoliwia wizanie nazw ze staymi
# poprzez indeksowane w typie NAZWA_names.
#

#START:body
my @consts;

my $name = <>;
die "Nieprawidowy format - nie podano nazwy" unless defined($name);

chomp $name;

# Odczytuje pozosta zawarto pliku:
while (<>) {
  chomp;
  s/^\s*//; s/\s*$//;
  die "Nieprawidowy wiersz: $_" unless /^(\w+)$/;
  
  push @consts, $_;
}

# Generuje plik:
open(HDR, ">$name.h") or die "Nie mona otworzy $name.h: $!";
open(SRC, ">$name.c") or die "Nie mona otworzy $name.c: $!";

my $uc_name = uc($name);
my $array_name = $uc_name . "_names";

print HDR "/* Plik wygenerowany automatycznie - nie do edycji */\n";
print HDR "extern const char *$ {array_name}[];";
print HDR "typedef enum {\n  ";
print HDR join ",\n  ", @consts;
print HDR "\n} $uc_name;\n\n";

print SRC "/* Plik wygenerowany automatycznie - nie do edycji */\n";
print SRC "const char *$ {array_name}[] = {\n  \"";
print SRC join "\",\n  \"", @consts;
print SRC "\"\n};\n";

close(SRC);
close(HDR);
#END:body
