/** 
  * Ten plik zawiera wiele rnych przykadw, z ktrych aden nie jest na tyle
  * rozbudowany, aby umieszcza go w osobnym pliku.
  */

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <strings.h>
#include <math.h>

#include "tests.h"


extern char *optarg;
int exitcode = 0;

/**
 * Definicja exit() na potrzeby testw:
 */
#define exit(n) exitcode = n

/*START:check */
#define CHECK(LINE, EXPECTED)               \
  { int rc = LINE;                          \
    if (rc != EXPECTED)                     \
        ut_abort(__FILE__, __LINE__, #LINE,  rc, EXPECTED); }


void ut_abort(char *file, int ln, char *line, int rc, int exp) {
  fprintf(stderr, "%s line %d\n'%s': expected %d, got %d\n", 
                  file, ln, line, exp, rc);
  exit(1);
}
/*END:check*/

#undef exit

/************************************************************************
 * Z podrozdziau "Szybko algorytmu"
 ***********************************************************************/

typedef struct node Node;
struct node {
  Node *left;
  Node *right;
};

void getNodeAsString(const Node *node, char *buffer) {}

/*START:printtree*/
void printTree(const Node *node) {
  char buffer[1000];
  
  if (node) {
    printTree(node->left);
    
    getNodeAsString(node, buffer);
    puts(buffer);

    printTree(node->right);
  }
}
/*END:printtree*/

void printTree2(const Node *node) {
  char buffer[1000];
  
  /*START:printtree2*/
  while (node) {
    if (node->left) printTree(node->left);
    
    getNodeAsString(node, buffer);
    puts(buffer);
    
    node = node->right;
  }
  /*END:printtree2*/
}

/*START:printtree1*/

void printTreePrivate(const Node *node, char *buffer) {
  if (node) {
    printTreePrivate(node->left, buffer);
    
    getNodeAsString(node, buffer);
    puts(buffer);

    printTreePrivate(node->right, buffer);
  }
}

void newPrintTree(const Node *node) {
  char buffer[1000];

  printTreePrivate(node, buffer);
}
/*END:printtree1*/


/************************************************************************
 * Z podrozdziau "Szybko algorytmu"
 ***********************************************************************/

void linsearch() {
  int result;
  int n = 0;
  int i;
  int value = 0;
  int array[1];

  array[0] = 0;

  /*START:linsearch*/
  /* Szuka wartoci value w tablicy array; zwraca albo indeks
   * tej wartoci, albo -1 (jeli nie zostaa znaleziona).
   */
  
  result = -1;

  for (i = 0; i < n; i++) {
    if (array[i] == value) {
      result = i;
      break;
    }
  }
  /*END:linsearch*/
}

/* START: ex */
/* Obcina acuch, pozostawiajc ostatnie maxlen znakw. */

void string_tail(char *string, int maxlen) {
  int len = strlen(string);
  if (len > maxlen) {
    strcpy(string, string + (len - maxlen));
  }
}
/* END: ex */

/************************************************************************
 * Przetwarzanie wspbiene
 ************************************************************************/


void bad_strtok() {
/* START: strtok */
char buf1[BUFSIZ];
char buf2[BUFSIZ];
char *p, *q;

strcpy(buf1, "to jest test");
strcpy(buf2, "to nie zadziaa");

p = strtok(buf1, " ");
q = strtok(buf2, " ");
while (p && q) {
  printf("%s %s\n", p, q);
  p = strtok(NULL, " ");
  q = strtok(NULL, " ");
}
/* END: strtok */
}

 /***********************************************************************/
void usage() {
  fprintf(stderr,"Sposb uycia: \n");
  fprintf(stderr,"       string_tail: -c maxlen -s string -t -e expected\n");
  fprintf(stderr,"       CHECK: -C\n");
  exit(1);
}


/**
  * Test kodu
  */
int main(int argc, char **argv)
{
  int c;
  int count = 10;  
  char *string = "TEST";
  char *expected = "???";
  struct stat statBuf;

  while ((c = getopt(argc, argv, "tc:s:e:Ca:b:")) != EOF) {
    switch(c) {

      /* Testy funkcji string_tail */

    case 'c':  /* Pobierz licznik */
      count = atoi(optarg);
      break;

    case 'e':
      expected = optarg;
      break;

    case 's':  /* Pobierz acuch */
      string = optarg;
      break;

    case 't':  /* Wywoaj string_tail() */
      string_tail(string, count);
      if (strcmp(string, expected) != 0) 
      fail("string_tail: oczekiwano %s, otrzymano %s", expected, string);
      exit(0);
      break;

      /* Testy funkcji CHECK() */

    case 'C':
      /* test zakoczy si pomylnie */
      CHECK(stat("/tmp", &statBuf), 0);
      if (exitcode != 0) fail("Funkcja CHECK(/tmp) zwrcia warto rn od zera");

      fprintf(stderr,
    "Oczekuje komunikatu 'stat(\"/tmpxx\", &statBuf)': oczekiwano 0, otrzymano -1'\n");
      CHECK(stat("/tmpxx", &statBuf), 0);
      if (exitcode != 1) fail("CHECK(/tmpxx) oczekiwano 1, otrzymano %d", exitcode);
      exit(0);
      break;

    default:
      usage();
      exit(1);
    }
  }
  usage();
  exit(1);
}


