/**
  * Przykad klasy auto_ptr jzyka C++ z podrozdziau "Jak zrwnoway zasoby".
  */

#include <stdio.h>
#include <stl.h>

typedef struct {
  int i;
} Node;

template <class X> class auto_ptr {
private:
  X* ptr;
  mutable bool owns;
public:
  typedef X element_type;
  explicit auto_ptr(X* p = 0)  : ptr(p), owns(p) {}
  auto_ptr(const auto_ptr& a)  : ptr(a.ptr), owns(a.owns) {
    a.owns = 0;
  }
  template <class T> auto_ptr(const auto_ptr<T>& a) __STL_NOTHROW
    : ptr(a.ptr), owns(a.owns) {
      a.owns = 0;
  }
 
  auto_ptr& operator=(const auto_ptr& a) __STL_NOTHROW {
    if (&a != this) {
      if (owns)
        delete ptr;
      owns = a.owns;
      ptr = a.ptr;
      a.owns = 0;
    }
  }
  template <class T> auto_ptr& operator=(const auto_ptr<T>& a) __STL_NOTHROW {
    if (&a != this) {
      if (owns)
        delete ptr;
      owns = a.owns;
      ptr = a.ptr;
      a.owns = 0;
    }
  }
  ~auto_ptr() {
    if (owns)
      delete ptr;
  }
 
  X& operator*() const __STL_NOTHROW { return *ptr; }
  X* operator->() const __STL_NOTHROW { return ptr; }
};


//START:bad
void doSomething(void) {
  
  Node *n = new Node;

  try {
    // jakie dziaania
  }
  catch (...) {
    delete n;
    throw;
  }

  delete n;
}
//END:bad

//START:better1
void doSomething1(void) {
  
  Node n;
//END:better1
  n.i = 0;
//START:better1

  try {
    // jakie dziaania
  }
  catch (...) {
    throw;
  }
}
//END:better1

//START:better2
// Klasa opakowania dla zasobw typu Node
class NodeResource {
  Node *n;

 public:
  NodeResource() { n = new Node; }
  ~NodeResource() { delete n; }

  Node *operator->() { return n; }
};

void doSomething2(void) {
  
  NodeResource n;

  try {
    // jakie dziaania
  }
  catch (...) {
    throw;
  }
}
//END:better2

//START:better3
void doSomething3(void) {
  auto_ptr<Node> p (new Node);

  // Dostp do Node w formie p->...
  
  // Wze (Node) jest automatycznie usuwany na kocu
}
//END:better3
