package dbc;

/**
  * Przykad dla podrozdziau "Projektowanie kontraktowe" (kod na potrzeby eksperymentw).
  */

// START: ans_inv
/**
  * @invariant getSpeed() > 0 
  *        implies isFull()              // Nie moe by pusty
  * @invariant getSpeed() >= 0 && 
  *        getSpeed() < 10               // Test zakresu
  */

// END: ans_inv
class dbc_ex {

  private int mySpeed = 0;
  private boolean myIsFull = false;


  /**
    * Zwraca szybko od 0 (wyczony) do 10.
    */
  public int getSpeed() {
    return mySpeed;
  }

  // START: ans_prepost
  /**
    * @pre Math.abs(getSpeed() - x) <= 1 // Zmiana tylko o 1
    * @pre x >= 0 && x < 10              // Test zakresu
    * @post getSpeed() == x              // Zgodno z dan szybkoci
    */
  public void setSpeed(final int x) 

  // END: ans_prepost
  {
    mySpeed = x;
  }


  boolean isFull() {
    return myIsFull;
  }

  // START: ans_prepost
  /**
    * @pre !isFull()                     // Nie wypenia dwa razy
    * @post isFull()                     // Sprawdza, czy wykonano
    */
  void fill() 

  // END: ans_prepost
  {
    myIsFull = true;
  }

  // START: ans_prepost
  /**
    * @pre isFull()                      // Nie oprnia dwa razy
    * @post !isFull()                    // Sprawdza, czy wykonano
    */
  void empty() 

  // END: ans_prepost
  {
    myIsFull = false;
  }

  // START: jig
  public static void main(String args[]) {

    // Tworzy blender na potrzeby testw.
    dbc_ex blender = new dbc_ex();

    // I testuje blender zgodnie z acuchem odczytanym ze standardowego wejcia.
    try {
      int a;
      char c;
      
      while ((a = System.in.read()) != -1) {
        
        c = (char)a;
        
        if (Character.isWhitespace(c)) {
          continue;
        }
        
        if (Character.isDigit(c)) {
          blender.setSpeed(Character.digit(c, 10));
        }
        else {
          switch (c) {
            case 'F': blender.fill(); 
                      break;
            case 'E': blender.empty(); 
                      break;
            case 's': System.out.println("SPEED: " +
                                         blender.getSpeed()); 
                      break;
            case 'f': System.out.println("FULL " +
                                         blender.isFull());
                      break;
            default: throw new RuntimeException(
                      "Unknown Test directive");
          }
        }
      } 
    }
    catch (java.io.IOException e) {
      System.err.println("Test jig zakoczy si niepowodzeniem: " + e.getMessage());
    }

    System.err.println("Zakoczono miksowanie\n");
    System.exit(0);

  }
  // END: jig

}
