/**
  * Prosty zbir polece systemu grafiki wia.
  */

#include <stdio.h>
#define ARG    1
#define NO_ARG 0

#define ARRAY_SIZE(A) (sizeof(A)/sizeof(A[0]))

/* Dummy handler functions */
void doSelectPen(int cmd, int arg)  { printf("P %d\n", arg); }
void doPenUp(int cmd, int arg)      { printf("U\n", arg); }
void doPenDown(int cmd, int arg)    { printf("D\n", arg); }
void doPenDir(int cmd, int arg)     { printf("%c %d\n", cmd, arg); }

/* Poniewa dymy do rozszerzalnoci tego jzyka, tworzymy analizator
 * skadniowy dziaajcy na podstawie tabeli. Kady wpis w tej tabeli
 * zawiera liter polecenia, flag okrelajc, czy to polecenie
 * wymaga argumentu, oraz nazw funkcji wywoywanej w celu obsug
 * tego polecenia. 
 */

/*START:table*/
typedef struct {
  char  cmd;              /* litera polecenia */
  int hasArg;             /* czy wymaga argumentu */
  void (*func)(int, int); /* funkcja do wywoania */
} Command;

static Command cmds[] = {
  { 'P',  ARG,     doSelectPen },
  { 'U',  NO_ARG,  doPenUp },
  { 'D',  NO_ARG,  doPenDown },
  { 'N',  ARG,     doPenDir },
  { 'E',  ARG,     doPenDir },
  { 'S',  ARG,     doPenDir },
  { 'W',  ARG,     doPenDir }
};
/*END:table*/

/* Funkcja szukajca polecenia liniowo przeszukuje tabel i zwraca */
/* albo pasujcy wpis, albo \CF{NULL}. */

/*START:findcmd*/
Command *findCommand(int cmd) {
  int i;

  for (i = 0; i < ARRAY_SIZE(cmds); i++) {
    if (cmds[i].cmd == cmd)
      return cmds + i;
  }

  fprintf(stderr, "Nieznane polecenie '%c'\n", cmd);
  return 0;
}
/*END:findcmd*/

/* Odczytuje liczbowy argument (zwraca TRUE, jeli znajdzie argument) */
/*START:getarg*/
int getArg(const char *buff, int *result) {
  return sscanf(buff, "%d", result) == 1;
}
/*END:getarg*/


/* Program jest do prosty: odczytuje wiersz, szuka polecenia, */
/* pobiera wymagany argument, po czym wywouje odpowiedni funkcj. */

int main(int argc, char **argv) {
  char buff[100];

  /*START:main*/
  while (fgets(buff, sizeof(buff), stdin)) {
    
    Command *cmd = findCommand(*buff);
    
    if (cmd) {
      int   arg = 0;
    
      if (cmd->hasArg && !getArg(buff+1, &arg)) {
        fprintf(stderr, "'%c' wymaga argumentu\n", *buff);
        continue;
      } 
    
      cmd->func(*buff, arg);
    }
  }
  /*END:main*/
}
