/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/

/*************************************************************************
 *   sm3.c		* Implementacja licznika słów z wykorzystaniem tabeli
 *************************************************************************/

#include <ctype.h>
#include <stdio.h>

typedef enum {LT, GT, QT, WORD, OTHER } CHAR_TYPE;
typedef enum {S, W, CMD, STR } STATE;
typedef enum {NONE, INC } ACTION;

typedef struct {
  STATE  nextState;
  ACTION action;
} TRANSITION;

TRANSITION transitions[4][5] = {
/*          LT           GT          QT         WORD        OTHER  */
/* S */{{ CMD,NONE }, {S,  NONE}, {S,  NONE}, {W,  INC},  {S,  NONE}},
/* W */{{ CMD,NONE }, {S,  NONE}, {S,  NONE}, {W,  NONE}, {S,  NONE}},
/*CMD*/{{ CMD,NONE }, {S,  NONE}, {STR,NONE}, {CMD,NONE}, {CMD,NONE}},
/*STR*/{{ STR,NONE }, {STR,NONE}, {CMD,NONE}, {STR,NONE}, {STR,NONE}}
};

CHAR_TYPE chtype(int ch) {
  if (ch == '<') return LT;
  if (ch == '>') return GT;
  if (ch == '"') return QT;
  if (isalpha(ch)) return WORD;
  return OTHER;
}

int main(int argc, char **argv) {

  int   ch;
  int   count = 0;
  STATE state = S;

  while ((ch = getchar()) != EOF) {

    TRANSITION t = transitions[state][chtype(ch)];

    switch (t.action) {
    case NONE: break;
    case INC:  count++; break;
    default:   fprintf(stderr, "Nieprawidłowa operacja %d\n", t.action);
    }
    state = t.nextState;
  }

  printf("Tekst zawierał %d słów%s\n", 
	 count, count == 1 ? "" : "s");
  return 0;
}



