/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
/** 
  * Ten plik zawiera wiele różnych przykładów w języku C, z których żaden 
  * nie jest wystarczająco duży, aby zasługiwał na umieszczenie w osobnym pliku.  
  */

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <strings.h>
#include <math.h>

#include "tests.h"


extern char *optarg;
int exitcode = 0;

/**
 * To przedefiniowanie funkcji exit jest paskudnym hackiem używanym do celów testowych
 */

#define exit(n) exitcode = n

#define CHECK(LINE, EXPECTED)               \
  { int rc = LINE;                          \
    if (rc != EXPECTED)                     \
        ut_abort(__FILE__, __LINE__, #LINE,  rc, EXPECTED); }


void ut_abort(char *file, int ln, char *line, int rc, int exp) {
  fprintf(stderr, "%s wiersz %d\n'%s': oczekiwano %d, otrzymano %d\n", 
                  file, ln, line, exp, rc);
  exit(1);
}

#undef exit

/************************************************************************
 * Ze wskazówki algorithm_speed.tip
 ***********************************************************************/

typedef struct node Node;
struct node {
  Node *left;
  Node *right;
};

void getNodeAsString(const Node *node, char *buffer) {}

void printTree(const Node *node) {
  char buffer[1000];
  
  if (node) {
    printTree(node->left);
    
    getNodeAsString(node, buffer);
    puts(buffer);

    printTree(node->right);
  }
}

void printTree2(const Node *node) {
  char buffer[1000];
  
  while (node) {
    if (node->left) printTree(node->left);
    
    getNodeAsString(node, buffer);
    puts(buffer);
    
    node = node->right;
  }
}


void printTreePrivate(const Node *node, char *buffer) {
  if (node) {
    printTreePrivate(node->left, buffer);
    
    getNodeAsString(node, buffer);
    puts(buffer);

    printTreePrivate(node->right, buffer);
  }
}

void newPrintTree(const Node *node) {
  char buffer[1000];

  printTreePrivate(node, buffer);
}


/************************************************************************
 * Ze wskazówki algorithm_speed.tip
 ***********************************************************************/

void linsearch() {
  int result;
  int n = 0;
  int i;
  int value = 0;
  int array[1];

  array[0] = 0;

  /* poszukaj 'value' w tablicy 'array' i zwróć
   * indeks lub -1, jeśli nie znajdziesz
   */
  
  result = -1;

  for (i = 0; i < n; i++) {
    if (array[i] == value) {
      result = i;
      break;
    }
  }
}

/* Obetnij ciąg do ostatniej długości maxlen */

void string_tail(char *string, int maxlen) {
  int len = strlen(string);
  if (len > maxlen) {
    strcpy(string, string + (len - maxlen));
  }
}

/************************************************************************
 * Ze wskazówki concurrency.tip
 ************************************************************************/


void bad_strtok() {
char buf1[BUFSIZ];
char buf2[BUFSIZ];
char *p, *q;

strcpy(buf1, "to jest test");
strcpy(buf2, "on nie będzie działać ");

p = strtok(buf1, " ");
q = strtok(buf2, " ");
while (p && q) {
  printf("%s %s\n", p, q);
  p = strtok(NULL, " ");
  q = strtok(NULL, " ");
}
}

 /***********************************************************************/
void usage() {
  fprintf(stderr,"Sposób używania: \n");
  fprintf(stderr,"       string_tail: -c maxlen -s string -t -e expected\n");
  fprintf(stderr,"       CHECK: -C\n");
  exit(1);
}


/**
  * Oprzyrządowanie testowe dla tego kodu
  */
int main(int argc, char **argv)
{
  int c;
  int count = 10;  
  char *string = "TEST";
  char *expected = "???";
  struct stat statBuf;

  while ((c = getopt(argc, argv, "tc:s:e:Ca:b:")) != EOF) {
    switch(c) {

      /* testy String_tail */

    case 'c':  /* Pobranie licznika */
      count = atoi(optarg);
      break;

    case 'e':
      expected = optarg;
      break;

    case 's':  /* Pobranie ciągu znaków */
      string = optarg;
      break;

    case 't':  /* Uruchom Truncate */
      string_tail(string, count);
      if (strcmp(string, expected) != 0) 
      fail("string_tail: oczekiwano %s otrzymano %s", expected, string);
      exit(0);
      break;

      /* Testy CHECK */
      /* hack użyt w celu zatrzymania */

    case 'c':
      /* to się uda */
      CHECK(stat("/tmp", &statBuf), 0);
      if (exitcode != 0) fail("CHECK(/tmp) zwrócił wartość niezerową");

      fprintf(stderr,
    "Oczekiwano komunikatu 'stat(\"/tmpxx\", &statBuf)': oczekiwano 0, otrzymano -1'\n");
      CHECK(stat("/tmpxx", &statBuf), 0);
      if (exitcode != 1) fail("CHECK(/tmpxx) oczekiwano 1, otrzymano %d", exitcode);
      exit(0);
      break;

    default:
      usage();
      exit(1);
    }
  }
  usage();
  exit(1);
}


