/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
/**
  * Przykłady asercji z podrozdziału "Kod łatwy do testowania".
  */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <limits.h>


double epsilon = 0.0001;
#define mySqrt sqrt


#ifdef __TEST__
#endif /* spurious */

#if (1) 

void testValue(double num, double expected) {
  double result = mySqrt(num);
  if (num < 0) {
    // Powinien mieć wartość NaN jeśli argument jest ujemny
    assert(isnan(result));    
  }
  else {
    // W przeciwnym razie powinien mieścić się w granicach tolerancji
    assert(fabs(expected-result) < epsilon); 
  }
}

void someTests() {
  testValue(-4.0, 0.0);    // Podstawowe testy
  testValue(0.0,  0.0);    
  testValue(64.0, 8.0);    
  testValue(ULONG_MAX, 65535.9999);
}

int main(int argc, char **argv) 
{
  argc--; argv++;       // pomiń nazwę programu

  if (argc < 2) {       // w przypadku braku argumentów wykonaj standardowe testy
    testValue(-4.0,  0.0);
    testValue( 0.0,  0.0);
    testValue( 2.0,  1.4142135624);
    testValue(64.0,  8.0);
    testValue(1.0e7, 3162.2776602);
  }
  else {                // w przeciwnym razie użyj argumentów
    double num, expected;

    while (argc >= 2) {
      num = atof(argv[0]);
      expected = atof(argv[1]);
      testValue(num,expected);
      argc -= 2;
      argv += 2;
    }
  }
  return 0;
}
#endif
