#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---
#
# Z podrozdziału "Jak zrównoważyć zasoby". Ilustracja dobrego równoważenia zasobów
#

def assert(c, msg="unknown failure")
  raise "Asercja nieudana: #{msg}" unless c
end

def count_open_files
  count=0
  ObjectSpace.each_object(File) do |f|
    count += 1 if !f.closed?
  end
  count
end


require 'bigdecimal'

class Customer
  attr :balance
  attr :name

  def initialize(name)
    @balance = BigDecimal("0")
    @name=name
    File.open(@name + ".rec", "w") {|f| f.puts @balance} # Tylko do testowania
  end

  def read_customer(file)
    @balance=BigDecimal(file.gets)
  end

  def write_customer(file)
    file.rewind
    file.puts @balance.to_s
  end

  def update_customer(transaction_amount)
    file=File.open(@name + ".rec", "r+")          # >--
    read_customer(file)                           #    |
    @balance = @balance.add(transaction_amount,2) #    |
    write_customer(file)                          #    |
    file.close                                    # <--
  end
end

assert(count_open_files ==0, "nie powinno być żadnych otwartych plików")

c=Customer.new("andy")
c.update_customer(1000.00)
assert(c.balance == 1000.00, "saldo powinno się zgadzać")

assert(count_open_files ==0, "nie powinno być żadnych otwartych plików")

class Customer

  def read_customer(file)
    @balance=BigDecimal(file.gets)
  end

  def write_customer(file)
    file.rewind
    file.puts @balance.to_s
  end

  def update_customer(transaction_amount)
    File.open(@name + ".rec", "r+") do |file|       # >--
      read_customer(file)                           #    |
      @balance = @balance.add(transaction_amount,2) #    |
      write_customer(file)                          #    |
    end                                             # <--
  end
end

c=Customer.new("andy")
c.update_customer(1000.00)
assert(c.balance == 1000.00, "saldo powinno się zgadzać")

assert(count_open_files ==0, "nie powinno być żadnych otwartych plików")
