#!/usr/bin/perl -w
#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---

use strict;

# Z podrozdziału "Operowanie na tekście ",
# Odczytaj ze standardowego wejścia plik zawierający
#
#  wiersz 1:  nazwa
#  wiersz 2:  stała1
#  wiersz 3:  stała2
#    :         :
#
# Tworzy plik name.h, zawierający
#
#   |extern const char* NAME_names[];
#   |typedef enum {
#   |   constant1,
#   |   constant2,
#   |     :
#   | } NAME;
#
# oraz plik name.c, zawierający
#
#   | const char* NAME_names[] = {
#   |   "constant1",
#   |   "constant2",
#   | };
#
# Plik nagłówkowy powinien być włączony do Twojego zwykłego
# kodu. To pozwala powiązać nazwę ze stałą
# poprzez indeksację z NAME_names
#

my @consts;

my $name = <>;
die "Nieprawidłowy format – brakująca nazwa" unless defined($name);

chomp $name;

# Odczytaj pozostałą część pliku
while (<>) {
  chomp;
  s/^\s*//; s/\s*$//;
  die "Nieprawidłowy wiersz: $_" unless /^(\w+)$/;
  
  push @consts, $_;
}

# Teraz wygeneruj plik
open(HDR, ">$name.h") or die "Nie można otworzyć $name.h: $!";
open(SRC, ">$name.c") or die "Nie można otworzyć $name.c: $!";

my $uc_name = uc($name);
my $array_name = $uc_name . "_names";

print HDR "/* Plik wygenerowany automatycznie – nie edytuj */\n";
print HDR "extern const char *$ {array_name}[];";
print HDR "typedef enum {\n  ";
print HDR join ",\n  ", @consts;
print HDR "\n} $uc_name;\n\n";

print SRC "/* Plik wygenerowany automatycznie – nie edytuj */\n";
print SRC "const char *$ {array_name}[] = {\n  \"";
print SRC join "\",\n  \"", @consts;
print SRC "\"\n};\n";

close(SRC);
close(HDR);
