#!/usr/bin/perl -w
#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---
use strict;

# Wywołuj z nazwą programu do testowania

my $prog = shift or die "Brakuje programu do testowania";

# Testuj wszystkie kombinacje czasu akceptowanego przez parser czasu

$| = 1;
# Test 1. Test <godzina>am|pm

print "hh am|pm    ";
for (my $hour = 0; $hour < 12; $hour++) {
  check("$ {hour}am", 60*$hour);
  check("$ {hour}pm", 60*($hour+12));
  print "..";
}

# Test 2. Poza zakresem <godzina>am|pm

check("13am", -1); check("12pm", -1); check("999am", -1);

print "\n";

# Test 3. Sprawdzenie formatu hh:mm times

my $ans = 0;

print "hh:mm       ";

for (my $hour = 0; $hour < 24; $hour++) {
  print ".";
  for (my $min = "00"; $min lt "60"; $min++) {
    check("$hour:$min", $ans);
    $ans++;
  }
}
print "\n";

# Test 4. Format hh:mm am/pm times

$ans = 0;
print "hh:mm am/pm ";
for (my $hour = 0; $hour < 12; $hour++) {
  print "..";
  for (my $min = "00"; $min lt "60"; $min++) {
    check("$hour:$ {min}am", $ans);
    check("$hour:$ {min}pm", $ans+12*60);
    $ans++;
  }
}
print "\n";

# kilka dziwnych wartości na koniec

check("24:00", -1); check("goofy", -1); check("1:1", -1);
check("1:0023", -1); check("13:34am", -1);

#
# Uruchomienie programu timeparser dla argumnentu arg1, sprawdzenie wyników w arg2
#
sub check($$) {
  my $time = shift;
  my $expected = shift;
  my $result = `$prog $time 2>/dev/null`;
  my ($got) = split ' ', $result;

  if ($expected < 0) {
    if ($? == 0) {
      die "$prog $time -> powinno się nie powieść, ale zwrócił wynik $got";
    }
  }
  elsif ($got != $expected) {
    die "$prog $time  -> zwrócił $got, oczekiwano $expected";
  }
}
  
