/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
package dbc;

import java.util.Enumeration;
import java.util.Vector;

/**
  * Z podrozdziału „Projektowanie według kontraktu” – przykład wstawiania na listę.
  * Można stworzyć listę cykliczną zmieniając zaledwie kilka linijek.
  */


/**
  * @invariant forall Node n in elements() |
  *    n.prev() != null
  *      implies
  *         n.value().compareTo(n.prev().value()) > 0
  */

public class dbc_list {

  /**
    * @pre contains(aNode) == false
    * @post contains(aNode) == true
    */
  public void insertNode(final Node aNode) {
    // ...

    if (myFirst == null) {
      myFirst = aNode;
      myLast = aNode;
      aNode.setNext(null);
      aNode.setPrev(null);
    }
    else {
      myLast.setNext(aNode);
      aNode.setNext(null);
      aNode.setPrev(myLast);
      myLast = aNode;
     }
  }

  /**
    * Zwraca pierwszy węzeł na liście
    */
  public Node first() {
    return myFirst;
  }

  /**
    * Zwraca ostatni węzeł na liście
    */
  public Node last() {
    return myLast;
  }

  /**
    * Czy lista zawiera dany węzeł?
    */
  public boolean contains(final Node aNode) {
    Node itr = myFirst;
    if (itr == null)
      return false;
    boolean result = false;
    while (true) {
      if (itr.value().equals(aNode.value())) {
        result = true;
        break;
      }
      if (itr == myLast) {
        break;
      }
      itr = itr.next();
    }
    return result;
  }

  /**
    * Zwraca listę jako wyliczenie.
    */
  public Enumeration elements() {
    Vector v = new Vector();
    Node itr = myFirst;
    if (itr != null) {
      while (true) {
        v.addElement(itr);
        if (itr == myLast) {
          break;
        }
        itr = itr.next();
      }
    }
    return v.elements();
  }

  /**
    * Wyświetl listę jako ciąg znaków.
    */
  public String toString() {
    StringBuffer ret = new StringBuffer();
    ret.append("\ndbc_list: Pierwszy = " + myFirst.value() + 
                           " Ostatni = " + myLast.value() + "\n");
    Node itr = myFirst;
    if (itr != null) {
      while (true) {
        ret.append("\t" + itr.toString() + "\n");
        if (itr == myLast) {
          break;
        }
        itr = itr.next();
      }
    }
    return ret.toString();
  }

  /**
    * Sprawdzenie asercji (zobacz też Assert)
    */
  public static void check(boolean aCondition) {
    if (!aCondition) {
      System.out.println("==== Asercja nieudana ====");
      Thread.dumpStack();
      System.exit(1);
    }
  }

  private Node myFirst;
  private Node myLast;

  /**
    * Test klasy.
    */
  public static void main(String[] args) { 
    dbc_list list = new dbc_list();
    Node a = new Node("TestA"); list.insertNode(a);
    Node b = new Node("TestB"); list.insertNode(b);
    Node c = new Node("TestC"); list.insertNode(c);
    check(a != b);
    check(b != c);
    check(a.next() == b);
    check(b.next() == c);
    check(c.prev() == b);
    check(b.prev() == a);
    System.err.println ("dbc_list passed.");
  }

}
