/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
package com.pragprog.sample;

public class ShapeInterface { // for complilation
/**
  * Z podrozdziału „Refaktoryzacja” zrefaktoryzowana wersja
  * kodu.
  */
public interface Geometry {    
    public double area();
}

public class Square implements Geometry {
  private double size;
  public Square(double new_size) {
    size=new_size;
  }
  public double area() {
    return size*size;
  }
}

public class Circle implements Geometry {
  private double radius;
  public Circle(double new_radius) {
    radius = new_radius;
  }
  public double area() {
    return Math.PI*radius*radius; // pi*r^2
  }
}

public class IrregularQuadrilateral implements Geometry {
  private double side1, side2, side3, side4;

  public IrregularQuadrilateral(double new_side1, double new_side2, 
                                double new_side3, double new_side4) {
    side1= new_side1;
    side2= new_side2;
    side3= new_side3;
    side4= new_side4;
  }
  public double area() {
    return side1 * side2 * side3 * side4;
  }
}


} // wrapper kompilacji

