#!/bin/sh
#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---

CMD="java dbc.dbc_ex"
failcount=0

expect_okay() {
    if echo "$*" | $CMD #>/dev/null 2>&1
    then
      :
    else
      echo "NIEPOWODZENIE! $*"
      failcount=`expr $failcount + 1`
    fi
}

expect_fail() {
    if echo "$*" | $CMD >/dev/null 2>&1
    then
      echo "NIEPOWODZENIE! (oczekiwane niepowodzenie): $*"
      failcount=`expr $failcount + 1`
    fi
}

report() {
  if [ $failcount -gt 0 ]
  then
    echo -e "\n\n*** TESTÓW NIEUDANYCH: $failcount\n"
    exit 1 # W przypadku, gdy ten kod jest częścią większego programu
  else
    exit 0 # W przypadku, gdy ten kod jest częścią większego programu
  fi
}

#
# Uruchomienie testów
#

expect_okay F123456789876543210E # Powinien przejść
expect_fail F5    # Niepowodzenie, szybkość za wysoka
expect_fail 1     # Niepowodzenie, pusty 
expect_fail F10E1 # Niepowodzenie, pusty 
expect_fail F1238 # Niepowodzenie, pominięcie
expect_okay FE    # Nigdy się nie włącza
expect_fail F1E   # Opróżnianie podczas działania
expect_okay F10E  # Spodziewany wynik ok
report            # Zgłoszenie wyników
