﻿using System;

namespace Marketplace.Users.Domain.Shared
{
    public static class DomainExceptions
    {
        public class ProfanityFound : Exception
        {
            public ProfanityFound(string text)
                : base($"Znaleziono wulgaryzmy w tekście: {text}") { }
        }

        public class InvalidEntityState : Exception
        {
            public InvalidEntityState(object entity, string message)
                : base(
                    $"Zmiana stanu encji {entity.GetType().Name} została odrzucona, {message}"
                ) { }
        }
    }
}