using System;
using Marketplace.Framework;

namespace Marketplace.Domain.ClassifiedAd
{
    public class PictureSize : Value<PictureSize>
    {
        public int Width { get; internal set; }
        public int Height { get; internal set; }

        internal PictureSize() { }

        public PictureSize(int width, int height)
        {
            if (width <= 0)
                throw new ArgumentOutOfRangeException(
                    nameof(width),
                    "Szeroko zdjcia musi by liczb dodatni");

            if (height <= 0)
                throw new ArgumentOutOfRangeException(
                    nameof(height),
                    "Wysoko zdjcia musi by liczb dodatni");

            Width = width;
            Height = height;
        }
    }
}