import { AfterViewInit, Component, ViewChild } from '@angular/core';
import { ProductDetailComponent } from '../product-detail/product-detail.component';
import { Product } from '../product';

@Component({
  selector: 'app-product-list',
  templateUrl: './product-list.component.html',
  styleUrls: ['./product-list.component.css']
})
export class ProductListComponent implements AfterViewInit {

  selectedProduct: Product | undefined;
  @ViewChild(ProductDetailComponent) productDetail: ProductDetailComponent | undefined;
  products: Product[] = [
    {
      name: 'Kamera internetowa',
      price: 100
    },
    {
      name:  'Mikrofon',
      price: 200
    },
    {
      name: 'Klawiatura bezprzewodowa',
      price: 85
    }
  ];

  ngAfterViewInit(): void {
    if (this.productDetail) {
      console.log(this.productDetail.product);
    }
  }

  onBuy() {
    window.alert(`Właśnie kupiłeś ${this.selectedProduct?.name}!`);
  }

}
