﻿#! /bin/awk -f

#  $1   $2    $3  $4   $5         $6     $7
# konto:haslo:uid:gid:komentarz:katalog:powloka

BEGIN { FS = ":" }

# name[]    --- indeksowana nazwami kont
# uid[]     --- indeksowana wartosciami uid

# przy duplikatach decyduje kolejnosc

{
    if ($1 in name) {
        if ($3 in uid)
            ;   # konto i uid sa identyczne, nic nie robic
        else {
            print name[$1] > "dupusers"
            print $0 > "dupusers"
            delete name[$1]

            # usuniecie zachowanego wpisu z taka sama nazwa konta i innym uid
            remove_uid_by_name($1)
        }
    } else if ($3 in uid) {
        # wiadomo, ze w name nie ma $1, wiec zapisujemy wpisy z powielonym ID
        print uid[$3] > "dupids"
        print $0 > "dupids"
        delete uid[$3]

        # usuniecie wpisu z tym samym uid ale inna nazwa konta
        remove_name_by_uid($3)
    } else
        name[$1] = uid[$3] = $0     # pierwsze wystapienie wpisu
}

END {
    for (i in name)
        print name[i] > "unique1"

    close("unique1")
    close("dupusers")
    close("dupids")
}

function remove_uid_by_name(n,     i, f)
{
    for (i in uid) {
        split(uid[i], f, ":")
        if (f[1] == n) {
            delete uid[i]
            break
        }
    }
}

function remove_name_by_uid(id,    i, f)
{
    for (i in name) {
        split(name[i], f, ":")
        if (f[3] == id) {
            delete name[i]
            break
        }
    }
}
