#! /bin/sh -

# newuids --- wypisuje jeden albo wicej wolnych numerow UID
#
# Stosowanie:
#     newuids [-c N] plik-listy-zajetych-uid
#     -c N      wypisuje N wolnych uid

count=1     # liczba uid do wypisania

# przetwarzanie argumentow
while getopts "c:" opt
do
    case $opt in
    c) count=$OPTARG ;;
    esac
done

shift ($($OPTIND - 1))

IDFILE=$1

awk -v count=$count '
    BEGIN {
        for (i = 1; getline id > 0; i++)
            uidlist[i] = id
        close(idlist)

        totalids = i

        for(i = 2; i <= totalids; i++) {
            if (uidlist[i-1] != uidlist[i]) {
                for (j = uidlist[i-1] + 1; j < uidlist[i]; j++) {
                    print j
                    if (--count == 0)
                        exit
                }
            }
        }
    }' $IDFILE
