#! /bin/sh -
# =======================================================================
# To skrypt powoki bdcy interfejsem narzdzia kontroli pisowni.
# Schemat lokalizacji okrelajcy jzyk dokumentu mona ustawi jawnie
# opcj --locale, albo niejawnie, za porednictwem zmiennej rodowiskowej
# LANG.  Rnica w tych ustawieniach polega na tym, e w tym ostatnim
# przypadku w obliczu braku plikw odpowiednich do schematu lokalizacji
# zaadowany zostanie sownik jzyka angielskiego z domyln dla tego
# jzyka list przyrostkw; tymczasem jawne ustawienie wymusza wskazanie
# przynajmniej jednego pliku sownika odpowiedniego dla danego schematu
# lokalizacji.
#
# Stosowanie:
#	myspell [ --? ] \
#		[ --dictionary plik_sownika ] \
#		[ --help ] \
#		[ --locale nazwa_schematu_lokalizacji ] \
#		[ --privatedictionary plik_sownika_prywatnego ] \
#		[ --strip  ] \
#		[ --suffixrules plik_regu_przyrostkw ] \
#		[ --verbose ] \
#		[ --version ] \
#		[ +plik_sownika ] \
#		[ =plik_regu_przyrostkw ] \
#		[ -- ] \
#		[ plik(i) ]
#
# ======================================================================
IFS='
 	'

PATH=/bin:/usr/bin
export PATH

DATE="[26-Jun-2003]"
PROGRAM=$0
VERSION=myspell-1.00

error()
{
	echo BD: "$@" >&2
	usage_and_exit 1
}

usage_and_exit()
{
	# echo DIAGNOSTYKA: usage_and_exit...
	cat >&2 <<EOF
Stosowanie:
$PROGRAM	[ --? ] [ --dictionary plik_sownika ] [ --help ] \\
			[ --locale nazwa_schematu_lokalizacji ] \\
                  [ --privatedictionary plik_sownika_prywatnego ] \\
			[ --suffixrules plik_regu_przyrostkw ] [ --verbose ] \\
			[ --version ] [ +plik_sownika ] [ =plik_regu_przyrostkw ] [ -- ] \\
			[ plik(i) ]
EOF
	exit $1
}

version_and_exit()
{
	echo "$VERSION $DATE" >&2
	exit 0
}

LIBDIR=`dirname $PROGRAM`/../share/myspell/$VERSION
LOCALEDIR=$LIBDIR/locale

# Katalog tymczasowy-projektowy
# LIBDIR=/u/sy/beebe/xml/shbook/awk

# Katalog tymczasowy do celw diagnostycznych
# AWK="echo awk"
AWK=${AWK:-/usr/local/bin/nawk}

DICTIONARIES=
PRIVATEDICTIONARIES=
SPELLFLAGS=
SUFFIXRULES=

# Jeli ustawiono schemat lokalizacji, trzeba zaadowa odpowiedni zestaw sownikw,
# o ile s dostpne
if test -n "$LANG" -a -d "$LOCALEDIR/$LANG"
then
	DICTIONARIES="`find $LOCALEDIR/$LANG/*.dict`"
	SUFFIXRULES="`find $LOCALEDIR/$LANG/*.sfx`"
fi

while test $# -gt 0
do
	case $1 in
	-- )			# wszystko inne to pliki
		shift
		break
		;;

	-dictionary | -dictionar | -dictiona | -diction | -dictio | \
	-dicti | -dict | -dic | -di | -d | \
	--dictionary | --dictionar | --dictiona | --diction | --dictio | \
	--dicti | --dict | --dic | --di | --d )
		shift
		DICTIONARIES="$DICTIONARIES $1"
		;;

	-help | -hel | -he | -h | \
	--help | --hel | --he | --h | \
	'-?' )
		usage_and_exit 0
		;;

	-locale | -local | -loca | -loc | -lo | -l | \
	--locale | --local | --loca | --loc | --lo | --l )
		shift
		if test -d $LOCALEDIR/$1
		then
			DICTIONARIES="`find $LOCALEDIR/$1/*.dict`"
			test -z "$DICTIONARIES" && error Brak sownikw dla lokalizacji $1
		else
			error Brak sownikw dla lokalizacji $1
		fi
		;;

	-privatedictionary | -privatedictionar | -privatedictiona | \
	-privatediction | -privatedictio | -privatedicti | \
	-privatedict | -privatedic | -privatedi | -privated | \
	-private | -privat | -priva | -priv | -pri | -pr | -p | \
	--privatedictionary | --privatedictionar | --privatedictiona | \
	--privatediction | --privatedictio | --privatedicti | \
	--privatedict | --privatedic | --privatedi | --privated | \
	--private | --privat | --priva | --priv | --pri | --pr | --p )
		shift
		PRIVATEDICTIONARIES="$PRIVATEDICTIONARIES +$1"
		;;

	-strip | -stri | -str | -st | \
	--strip | --stri | --str | --st )
		SPELLFLAGS="$SPELLFLAGS -strip"
		;;

	-suffixrules | -suffixrules | -suffixrule | -suffixrul | \
	-suffixru | -suffixr | -suffix | -suffi | -suff | -suf | \
	-su | -s | \
	--suffixrules | --suffixrules | --suffixrule | --suffixrul | \
	--suffixru | --suffixr | --suffix | --suffi | --suff | --suf | \
	--su | --s )
		shift
		SUFFIXRULES="$SUFFIXRULES =$1"
		;;

	-verbose | -verbos | -verbo | -verb | -ver | -ve | -v | \
	--verbose | --verbos | --verbo | --verb | --ver | --ve | --v )
		SPELLFLAGS="$SPELLFLAGS -verbose"
		;;

	-version | -versio | -versi | -vers | \
	--version | --versio | --versi | --vers )
		version_and_exit
		;;

	+*)
		PRIVATEDICTIONARIES="$PRIVATEDICTIONARIES $1"
		;;

	=*)
		SUFFIXRULES="$SUFFIXRULES $1"
		;;

	-*)
		error Nieznana opcja $1
		usage_and_exit 1
		;;

	*)			# wszystko inne musi by plikiem
		break
	esac
	shift
done

test -n "$DICTIONARIES" && export DICTIONARIES && echo "DIAGNOSTYKA: DICTIONARIES = $DICTIONARIES"

$AWK -f $LIBDIR/spell.awk -- $PRIVATEDICTIONARIES $SUFFIXRULES "$@"
