<?php
/*
Template Name: Front End Post Editor
*/ 

get_header(); ?>

		<div id="primary">
			<div id="content" role="main">

				<?php while ( have_posts() ) : the_post(); ?>

					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<header class="entry-header">
							<h1 class="entry-title"><?php the_title(); ?></h1>
						</header><!-- .entry-header -->
					
						<div class="entry-content">
							<?php the_content(); ?>
							
							<?php
								// Edytor wpisów
$settings = array(
	'wpautop' => true, // Użyć wpautop?
	'media_buttons' => false, // Pokaż przyciski wstaw/wyślij
	'textarea_name' => $editor_id, // Zmienia nazwę pola tekstowego, można tu użyć nawiasów kwadratowych
	'textarea_rows' => get_option('default_post_edit_rows', 10), // rows="..."
	'teeny' => true, // Wyświetla minimalną konfigurację edytora używaną w Press This
	'tinymce' => true, // Ładuje TinyMCE, można użyć w celu przekazania ustawień bezpośrednio do TinyMCE przy użyciu array()
	'quicktags' => true // Ładuje Quicktags, można użyć do przekazania ustawień bezpośrednio do Quicktags przy użyciu array());
);

// echo '<form action="" method="post" target="_self">';
wp_editor('Wpisz tu swój przepis', 'submitrecipe', $settings );
// echo '<input type="submit" value="Wyślij przepis" /></form>';
							?>
							
						</div><!-- .entry-content -->
						<footer class="entry-meta">
							<?php edit_post_link( __( 'Edytuj', 'twentyeleven' ), '<span class="edit-link">', '</span>' ); ?>
						</footer><!-- .entry-meta -->
					</article><!-- #post-<?php the_ID(); ?> -->

				<?php endwhile; // Koniec pętli. ?>

			</div><!-- #content -->
		</div><!-- #primary -->

<?php get_footer(); ?>