<div <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php
    // Własne pole z adresem URL
    $CustomField = get_post_meta( get_the_ID(), 'URL', true ); 
    if ( !empty( $CustomField ) ) { 
?>
    <h2>
        <a href="<?php echo esc_url( $CustomField ) ?>"
          rel="bookmark" title="<?php the_title_attribute(); ?>">
            <?php the_title(); ?>
        </a>
        <?php echo $CustomField; ?>
    </h2>
    <div class="entry">
        <?php the_excerpt(); ?>
    </div>
    <p class="postmetadata">
        Kategoria: <?php the_category( ', ' ) ?>, <?php the_tags( 'tagi: ',
           ', ', '' ); ?> <small><?php the_time( 'F jS, Y' ) ?></small>
    </p>
<?php
    // Brak łącza
    } else { 
?>
    <h2><del><?php the_title(); ?></del></h2>
    <div class="entry">
        <p>To łącze jest uszkodzone. Powiadom o tym administratora!</p>
    </div>
    <p class="postmetadata">
        Uszkodzone łącze: <?php edit_post_link( 'Napraw je!', '', ' | ' ); ?>
        Kategoria: <?php the_category( ', ' ); ?>, <?php the_tags( 'tagi: ', ', ', '' ); ?> <small><?php the_time( 'F jS, Y' );
        ?></small>
    </p>
<?php } ?>
</div>