<?php get_header(); ?>

<div id="main-container">
    <section id="content-container">
    
    <?php 
        // Początek pętli
        if ( have_posts() ) : while ( have_posts() ) : the_post(); 
    ?>
    
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <header>
                <h2 class="entry-title">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">
                        <?php the_title(); ?>
                    </a>
                </h2>
                <p class="entry-meta">
                Opublikowano dnia <time datetime="<?php echo get_the_date(); ?>">
                    <?php the_time(); ?>,</time>
                autor: <?php the_author_link(); ?>

                <?php 
                    // Czy komentarze są otwarte?
                    if ( comments_open() ) : ?>
                    &bull; <?php comments_popup_link( 'Brak komentarzy', '1 komentarz', 'komentarzy: %' ); ?>
                <?php endif; ?>
                </p>
            </header>
            <?php
                // Treść
                the_content();
                
                // Wczytanie komentarzy, jeśli strona zawiera pojedynczy artykuł
                if ( is_singular() && comments_open() )
                comments_template( '', true );
            ?>
        </article>
        
    <?php 
        // Koniec pętli
        endwhile; 
        // W pętli nie ma nic do wyświetlenia?
        else : 
    ?>
    
        <article id="post-0" class="post no-results not-found">
            <header>
                <h2 class="entry-title">Nic nie znaleziono</h2>
            </header>
            <p>Przepraszamy, ale nic dla Ciebie nie znaleźliśmy. Spróbuj znaleźć to, czego szukałeś korzystając z wyszukiwarki.</p>
            <?php get_search_form(); ?>
        </article>
        
    <?php 
        // Koniec
        endif; 
    ?>
        
    </section> <!-- #main-container - koniec -->
    
<?php get_sidebar(); ?>

</div>

<?php get_footer(); ?>