<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>" />
    
    <title>
    <?php 
        // Print the right title
        if ( is_home () ) { 
            bloginfo( 'name' ); 
        } elseif ( is_archive() ) {
            single_cat_title(); echo ' &bull; ' ; bloginfo( 'name' ); 
        } elseif ( is_singular() ) { 
            single_post_title(); 
        } else { 
            wp_title( '', true ); 
        }
    ?>
    </title>
    
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
    
    <!-- Naprawia stronę w przeglądarkach Internet Explorer starszych od wersji 9
      by Remy Sharp http://remysharp.com/2009/01/07/html5-enabling-script/ -->
    <!--[if lt IE 9]>

    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
    
    <?php
        // Dodanie do kolejki kodu JavaScript dla zakorzenionych komentarzy, jeśli są włączone
        if ( is_singular() && get_option( 'thread_comments' ) )
            wp_enqueue_script( 'comment-reply' );
    
        // Wywołanie funkcji wp_head() powinno znajdować się przed znacznikiem zamykającym nagłówek
        wp_head();
    ?>
</head>